package fr.shortcircuit.tp9.web.definition;

import java.util.List;

import fr.shortcircuit.tp9.business.definition.IProductBO;
import fr.shortcircuit.tp9.model.Product;

/** @author Dimitri Dean DARSEYNE (D3), 
 * Published by Short-Circuit under Creative Commons (CC) Licensing: 
 * Authorship/Paternity, NO Commercial Use, NO Derivative
 * Please check for more informations:
 * http://creativecommons.org/licenses/by-nc-nd/2.0/
 *
 * Auteur Dimitri Dean DARSEYNE (D3),
 * Publié par Short-Circuit sous license Creative Commons (CC):
 * Paternité, PAS d'Utilisation Commerciale, pas de Dérivés/Modifications
 * Pour plus d'informations, se rendre sur:
 * http://creativecommons.org/licenses/by-nc-nd/2.0/fr/ 
 * 
 * @since Short-Circuit 1999
 */

public interface IProductSearchBean 
{
	//Search methods
	public String search();
	public void keySearch();
	public List<Product> getMatchingProducts();
	public List<String> complete(String prefix);
	
	//Getters & Setters
	public IProductBO getProductBO();
	public Product getProductResult();
	public Product getProductKeyResult();
	public String getStrProduct();
	
	public void setProductBO(IProductBO productBO);
	public void setProductResult(Product productResult);
	public void setProductKeyResult(Product productKeyResult);
	public void setStrProduct(String strProduct);	
}
