package fr.shortcircuit.tp9.web.definition;

import java.util.Date;
import java.util.List;

import javax.faces.component.html.HtmlDataTable;

import fr.shortcircuit.tp9.business.definition.IProductBO;
import fr.shortcircuit.tp9.model.Product;

/** @author Dimitri Dean DARSEYNE (D3), 
 * Published by Short-Circuit under Creative Commons (CC) Licensing: 
 * Authorship/Paternity, NO Commercial Use, NO Derivative
 * Please check for more informations:
 * http://creativecommons.org/licenses/by-nc-nd/2.0/
 *
 * Auteur Dimitri Dean DARSEYNE (D3),
 * Publié par Short-Circuit sous license Creative Commons (CC):
 * Paternité, PAS d'Utilisation Commerciale, pas de Dérivés/Modifications
 * Pour plus d'informations, se rendre sur:
 * http://creativecommons.org/licenses/by-nc-nd/2.0/fr/ 
 * 
 * @since Short-Circuit 1999
 */

public interface IProductBean
{
	//Business & services access
	public List<Product> 	getAllProduct();
	public String 			searchProduct();
	public void 			getPdf();
 
 	//Beans accessors
	public IProductBO 		getProductBO();
	public IProductEditBean getProductEditBean();
	public IKeyRepository 	getKeyRepository();

	//Web dataTable wiring/binding
	public HtmlDataTable 	getDataTable();
	public String 			getSortColumn();
	public boolean 			isSortAscending();
	public int 				getRowCount();

	//Misc
	public Date 			getDate();
	public void 			setDate(Date date);

	//Beans mutators
	public void 			setProductBO(IProductBO productBO);
	public void 			setKeyRepository(IKeyRepository keyRepository);
	public void 			setProductEditBean(IProductEditBean productEditBean);

	//Web dataTable setters
	public void 			setDataTable(HtmlDataTable dataTable);
	public void 			setSortColumn(String sortColumn);
	public void 			setSortAscending(boolean sortAscending);
	public void 			setRowCount(int rowCount);
}