package fr.shortcircuit.tp9.web.annotated;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.faces.application.FacesMessage;
import javax.faces.component.html.HtmlDataTable;

import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.beanutils.BeanPredicate;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.commons.collections.functors.AllPredicate;
import org.apache.commons.collections.functors.EqualPredicate;
import org.springframework.beans.factory.annotation.Autowired;

import fr.shortcircuit.tp9.business.definition.IProductBO;
import fr.shortcircuit.tp9.model.Product;
import fr.shortcircuit.tp9.web.ChartHelper;
import fr.shortcircuit.tp9.web.definition.IChartHelper;
import fr.shortcircuit.tp9.web.definition.IKeyRepository;
import fr.shortcircuit.tp9.web.definition.IProductBean;
import fr.shortcircuit.tp9.web.definition.IProductEditBean;
import fr.shortcircuit.tp9.web.util.FileDownloadHelper;
import fr.shortcircuit.tp9.web.util.WebHelper;

/** @author Dimitri Dean DARSEYNE (D3), 
 * Published by Short-Circuit under Creative Commons (CC) Licensing: 
 * Authorship/Paternity, NO Commercial Use, NO Derivative
 * Please check for more informations:
 * http://creativecommons.org/licenses/by-nc-nd/2.0/
 *
 * Auteur Dimitri Dean DARSEYNE (D3),
 * Publié par Short-Circuit sous license Creative Commons (CC):
 * Paternité, PAS d'Utilisation Commerciale, pas de Dérivés/Modifications
 * Pour plus d'informations, se rendre sur:
 * http://creativecommons.org/licenses/by-nc-nd/2.0/fr/ 
 * 
 * @since Short-Circuit 1999
 */

public class ProductAnnotatedBean implements IProductBean
{	
	//Spring annotation to declare the property auto-wiring 
	@Autowired(required=true)
	private IProductBO 				productBO;
	@Autowired(required=true)
	private IProductEditBean 		productEditBean;
	@Autowired(required=true)
	private IKeyRepository 			keyRepository;
	//chart
	@Autowired(required=true)
	private IChartHelper			chartHelper;
	
	//Page variables
	private HtmlDataTable 			dataTable;
	private String 					sortColumn 		= "id";
    private int                		rowCount       	= 10;
	private boolean 				sortAscending;

	
	//temp
	private Date					date;
	
	
	
	public ProductAnnotatedBean()
	{
		chartHelper = new ChartHelper();
	}
	
	/**
	 * 
	 * @return
	 */
	public List<Product> getAllProduct()
	{
		//return productBO.getAllProduct((sortAscending)? new BeanComparator(sortColumn) : new ReverseComparator(new BeanComparator(sortColumn)), dataTable.getRowIndex(), rowCount);		
		return productBO.getAllProduct((sortAscending)? new BeanComparator(sortColumn) : new ReverseComparator(new BeanComparator(sortColumn)));
	}
	
	public String searchProduct()
	{
		ArrayList<Predicate> listPredicate  = new ArrayList();

		listPredicate.add(new BeanPredicate("id", new EqualPredicate(((Product) dataTable.getRowData()).getId())));

		Predicate pAll                      =  new AllPredicate((Predicate[]) listPredicate.toArray(new Predicate[] {})); //AnyPredicate
		
		productEditBean.setCurrentProduct(productBO.getProduct(pAll)); 
		productEditBean.setStateDisplayValueOnly(true);
		
		return "productEdit";
	}
	
	public void getPdf()
    {
        try
        {
            FileDownloadHelper.returnFile(productBO.getPDF((sortAscending)? new BeanComparator(sortColumn) : new ReverseComparator(new BeanComparator(sortColumn))), 
            								"application/pdf", "Export.pdf");
        } 
        catch (Throwable t) {t.printStackTrace(); WebHelper.addMessage("generation NOk !", "Probleme dans la generation du document !", FacesMessage.SEVERITY_ERROR );}
    }
 	
	public IProductBO getProductBO()									{return productBO;}
	public IKeyRepository getKeyRepository()							{return keyRepository;}
	public IChartHelper getChartHelper()								{return chartHelper;}
	public HtmlDataTable getDataTable()									{return dataTable;}
	public String getSortColumn()										{return sortColumn;}
	public boolean isSortAscending()									{return sortAscending;}
	public IProductEditBean getProductEditBean()						{return productEditBean;}
	public int getRowCount()											{return rowCount;}
	public Date getDate()												{return date;}

	public void setProductBO(IProductBO productBO)						{this.productBO 		= productBO;}
	public void setKeyRepository(IKeyRepository keyRepository)			{this.keyRepository 	= keyRepository;}
	public void setChartHelper(IChartHelper chartHelper)				{this.chartHelper 		= chartHelper;}
	public void setDataTable(HtmlDataTable dataTable)					{this.dataTable 		= dataTable;}
	public void setSortColumn(String sortColumn)						{this.sortColumn 		= sortColumn;}
	public void setSortAscending(boolean sortAscending)					{this.sortAscending 	= sortAscending;}
	public void setProductEditBean(IProductEditBean productEditBean)	{this.productEditBean 	= productEditBean;}
	public void setRowCount(int rowCount)								{this.rowCount 			= rowCount;}
	public void setDate(Date date)										{this.date 				= date;}
	 
}
