package fr.shortcircuit.tp9.web;

import java.util.Arrays;
import java.util.List;

import javax.annotation.PostConstruct;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;

import lombok.Getter;
import lombok.Setter;

import org.primefaces.event.RowEditEvent;
import org.primefaces.model.LazyDataModel;

import fr.shortcircuit.tp9.business.definition.IProductBO;
import fr.shortcircuit.tp9.model.Product;
import fr.shortcircuit.tp9.web.definition.IProductExtendedBean;
import fr.shortcircuit.tp9.web.util.LazyProductDataModel;

/** @author Dimitri Dean DARSEYNE (D3), 
 * Published by Short-Circuit under Creative Commons (CC) Licensing: 
 * Authorship/Paternity, NO Commercial Use, NO Derivative
 * Please check for more informations:
 * http://creativecommons.org/licenses/by-nc-nd/2.0/
 *
 * Auteur Dimitri Dean DARSEYNE (D3),
 * Publié par Short-Circuit sous license Creative Commons (CC):
 * Paternité, PAS d'Utilisation Commerciale, pas de Dérivés/Modifications
 * Pour plus d'informations, se rendre sur:
 * http://creativecommons.org/licenses/by-nc-nd/2.0/fr/ 
 * 
 * @since Short-Circuit 1999
 */

public class ProductExtendedBean implements IProductExtendedBean
{
	//Injected references
	@Getter @Setter
	private IProductBO 				productBO;

	//PrimeFaces lazyDataModel
	@Getter @Setter
	private LazyDataModel<Product> 	lazyModel;  
	
	//p:datatable: filtering feature (mandatory)
	@Getter @Setter
	private List<Product> 			listFilteredProduct;	
	//p:datatable: single selection feature (mandatory)
	@Getter @Setter
	private Product					selectedProduct;
	//p:datatable: multiple selection feature (mandatory)
	@Getter @Setter
	private Product[]				selectedArrayProducts;
	//p:selectManyCheckbox for datatable column filtering 
	@Getter @Setter
	private String[] 				selectedOptions 			= {"id", "type", "designation", "genre", "realisateur", "musique", "scenario", "annee", "price"};

	
	
	public ProductExtendedBean() {}
	
	//@nnotation for bean lifecycle & initialization management 
	@PostConstruct
	public void init()
	{
		System.out.println("ProductExtendedBean: init: enter (PostConstructed), set productBO=" + productBO);

		lazyModel = new LazyProductDataModel(productBO);
	}
		
	public String processOperationForSelection()
	{
		System.out.println("AccountBean: processOperationForSelection: enter ! selectedArrayProducts=" + Arrays.toString(selectedArrayProducts));
		
		return null;
	}
	
	public String resetSelectedProducts()
	{
		selectedArrayProducts = null;
		
		return null;
	}
		
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//Edit Event
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	public void onEdit(RowEditEvent event) 
	{  
		System.out.println("ProductBean: onEdit: event=" + event.toString());
		System.out.println("ProductBean: onEdit: event=" + event.getObject() );		
		System.out.println("ProductBean: onEdit: event.source.selection=" + ((org.primefaces.component.datatable.DataTable) event.getSource()).getSelection());
		
		FacesContext.getCurrentInstance().addMessage(null, new FacesMessage("Product Edited", "" + ((Product) event.getObject()).getId()));  
	}  
	      
	public void onCancel(RowEditEvent event) 
	{  
		FacesContext.getCurrentInstance().addMessage(null, new FacesMessage("Product Cancelled", "" + ((Product) event.getObject()).getId()));  
	}  

	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//DataTable Column Rendering
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	public String processViewMinimum()				{selectedOptions 	= new String[] {"id", "type", "designation", "genre"};															return null;}
	public String processViewMiddle()				{selectedOptions 	= new String[] {"id", "type", "designation", "genre", "realisateur", "musique", "scenario"};					return null;}
	public String processViewAll()					{selectedOptions 	= new String[] {"id", "type", "designation", "genre", "realisateur", "musique", "scenario", "annee", "price"};	return null;}
	
	public boolean isColumnIdRendered() 			{return Arrays.asList(selectedOptions).contains("id");}
	public boolean isColumnTypeRendered() 			{return Arrays.asList(selectedOptions).contains("type");}
	public boolean isColumnDesignationRendered() 	{return Arrays.asList(selectedOptions).contains("designation");}
	public boolean isColumnGenreRendered() 			{return Arrays.asList(selectedOptions).contains("genre");}
	public boolean isColumnRealisateurRendered() 	{return Arrays.asList(selectedOptions).contains("realisateur");}
	public boolean isColumnMusiqueRendered() 		{return Arrays.asList(selectedOptions).contains("musique");}
	public boolean isColumnScenarioRendered() 		{return Arrays.asList(selectedOptions).contains("scenario");}
	public boolean isColumnAnneeRendered() 			{return Arrays.asList(selectedOptions).contains("annee");}
	public boolean isColumnPriceRendered() 			{return Arrays.asList(selectedOptions).contains("price");}
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//Derivated Property
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	public int getSelectedArrayProductsLength() 									{return (selectedArrayProducts != null)? selectedArrayProducts.length : 0;}
}
