package fr.shortcircuit.tp9.web;

import javax.faces.application.FacesMessage;

import fr.shortcircuit.tp9.business.definition.IProductBO;
import fr.shortcircuit.tp9.model.Product;
import fr.shortcircuit.tp9.web.definition.IKeyRepository;
import fr.shortcircuit.tp9.web.definition.IProductEditBean;
import fr.shortcircuit.tp9.web.util.WebHelper;

/** @author Dimitri Dean DARSEYNE (D3), 
 * Published by Short-Circuit under Creative Commons (CC) Licensing: 
 * Authorship/Paternity, NO Commercial Use, NO Derivative
 * Please check for more informations:
 * http://creativecommons.org/licenses/by-nc-nd/2.0/
 *
 * Auteur Dimitri Dean DARSEYNE (D3),
 * Publié par Short-Circuit sous license Creative Commons (CC):
 * Paternité, PAS d'Utilisation Commerciale, pas de Dérivés/Modifications
 * Pour plus d'informations, se rendre sur:
 * http://creativecommons.org/licenses/by-nc-nd/2.0/fr/ 
 * 
 * @since Short-Circuit 1999
 */

public class ProductEditBean implements IProductEditBean
{
	//Injected references
	private IProductBO 				productBO;
	private IKeyRepository 			keyRepository;
	
	//Session Associated references
	private Product					currentProduct;
	
	private boolean 				stateDisplayValueOnly = true;
	
	
	public ProductEditBean()
	{
		
	}
	
	public void editProduct()
	{
		stateDisplayValueOnly = false;
	}
	
	public void saveProduct()
	{
		stateDisplayValueOnly = true;
		
		//ici on doit normalement invoquer l'enregistrement de l'objet par le BO
		
		WebHelper.addMessageFromBundle(keyRepository.getResourceBundle(), "message.save.ok", "Enregistrement OK", FacesMessage.SEVERITY_INFO);
	}
	
	public IProductBO getProductBO()										{return productBO;}
	public Product getCurrentProduct()										{return currentProduct;}
	public boolean isStateDisplayValueOnly()								{return stateDisplayValueOnly;}
	public IKeyRepository getKeyRepository()								{return keyRepository;}

	public void setProductBO(IProductBO productBO)							{this.productBO 				= productBO;}
	public void setCurrentProduct(Product currentProduct)					{this.currentProduct 			= currentProduct;}
	public void setStateDisplayValueOnly(boolean stateDisplayValueOnly)		{this.stateDisplayValueOnly 	= stateDisplayValueOnly;}
	public void setKeyRepository(IKeyRepository keyRepository)				{this.keyRepository 			= keyRepository;}

}
