package fr.shortcircuit.tp9.web;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.faces.application.FacesMessage;
import javax.faces.component.html.HtmlDataTable;

import lombok.Getter;
import lombok.Setter;

import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.beanutils.BeanPredicate;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.commons.collections.functors.AllPredicate;
import org.apache.commons.collections.functors.EqualPredicate;

import fr.shortcircuit.tp9.business.definition.IProductBO;
import fr.shortcircuit.tp9.model.Product;
import fr.shortcircuit.tp9.web.definition.IChartHelper;
import fr.shortcircuit.tp9.web.definition.IKeyRepository;
import fr.shortcircuit.tp9.web.definition.IProductBean;
import fr.shortcircuit.tp9.web.definition.IProductEditBean;
import fr.shortcircuit.tp9.web.util.FileDownloadHelper;
import fr.shortcircuit.tp9.web.util.WebHelper;

/** @author Dimitri Dean DARSEYNE (D3), 
 * Published by Short-Circuit under Creative Commons (CC) Licensing: 
 * Authorship/Paternity, NO Commercial Use, NO Derivative
 * Please check for more informations:
 * http://creativecommons.org/licenses/by-nc-nd/2.0/
 *
 * Auteur Dimitri Dean DARSEYNE (D3),
 * Publié par Short-Circuit sous license Creative Commons (CC):
 * Paternité, PAS d'Utilisation Commerciale, pas de Dérivés/Modifications
 * Pour plus d'informations, se rendre sur:
 * http://creativecommons.org/licenses/by-nc-nd/2.0/fr/ 
 * 
 * @since Short-Circuit 1999
 */

public class ProductBean implements IProductBean
{	
	//Injected references
	@Getter @Setter
	private IProductBO 				productBO;
	@Getter @Setter
	private IProductEditBean 		productEditBean;
	@Getter @Setter
	private IKeyRepository 			keyRepository;
	//chart
	@Getter @Setter
	private IChartHelper			chartHelper;
	
	//Page variables
	@Getter @Setter
	private HtmlDataTable 			dataTable;
	@Getter @Setter
	private String 					sortColumn 		= "id";
	@Getter @Setter
    private int                		rowCount       	= 10;
	@Getter @Setter
	private boolean 				sortAscending;

	
	//temp
	@Getter @Setter
	private Date					date;
	
	
	
	public ProductBean()
	{
		chartHelper = new ChartHelper();
	}
	
	public List<Product> getAllProduct()
	{
		//return productBO.getAllProduct((sortAscending)? new BeanComparator(sortColumn) : new ReverseComparator(new BeanComparator(sortColumn)), dataTable.getRowIndex(), rowCount);		
		return productBO.getAllProduct((sortAscending)? new BeanComparator(sortColumn) : new ReverseComparator(new BeanComparator(sortColumn)));
	}
	
	public String searchProduct()
	{
		ArrayList<Predicate> listPredicate  = new ArrayList();

		listPredicate.add(new BeanPredicate("id", new EqualPredicate(((Product) dataTable.getRowData()).getId())));

		Predicate pAll                      =  new AllPredicate((Predicate[]) listPredicate.toArray(new Predicate[] {})); //AnyPredicate
		
		productEditBean.setCurrentProduct(productBO.getProduct(pAll)); 
		productEditBean.setStateDisplayValueOnly(true);
		
		return "productEdit";
	}
	
	public void getPdf()
    {
        try
        {
            FileDownloadHelper.returnFile(productBO.getPDF((sortAscending)? new BeanComparator(sortColumn) : new ReverseComparator(new BeanComparator(sortColumn))), 
            								"application/pdf", "Export.pdf");
        } 
        catch (Throwable t) {t.printStackTrace(); WebHelper.addMessage("generation NOk !", "Probleme dans la generation du document !", FacesMessage.SEVERITY_ERROR );}
    }
 		 
}
