package fr.shortcircuit.tp9.web;

import java.util.Locale;
import java.util.ResourceBundle;

import fr.shortcircuit.tp9.web.definition.IKeyRepository;

/** @author Dimitri Dean DARSEYNE (D3), 
 * Published by Short-Circuit under Creative Commons (CC) Licensing: 
 * Authorship/Paternity, NO Commercial Use, NO Derivative
 * Please check for more informations:
 * http://creativecommons.org/licenses/by-nc-nd/2.0/
 *
 * Auteur Dimitri Dean DARSEYNE (D3),
 * Publié par Short-Circuit sous license Creative Commons (CC):
 * Paternité, PAS d'Utilisation Commerciale, pas de Dérivés/Modifications
 * Pour plus d'informations, se rendre sur:
 * http://creativecommons.org/licenses/by-nc-nd/2.0/fr/ 
 * 
 * @since Short-Circuit 1999
 */

public class KeyRepository implements IKeyRepository
{
	private ResourceBundle 					resourceBundle;

	public KeyRepository()
	{
		init();
	}

	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//Init local config
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	
	public void init()
	{	
		createResourceBundle();
	}

	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//Resource
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	public void createResourceBundle()
	{
		System.out.println("KeyRepository: createResourceBundle: enter !");

		resourceBundle			= ResourceBundle.getBundle("message", Locale.FRENCH, Thread.currentThread().getContextClassLoader());
	}

	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//Getters & Setters
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	public ResourceBundle getResourceBundle()						{return resourceBundle;}

	public void setResourceBundle(ResourceBundle resourceBundle)	{this.resourceBundle 		= resourceBundle;}

}
