package fr.shortcircuit.tp9.service.reporting.annotated;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.List;

import com.lowagie.text.Element;
import com.lowagie.text.PageSize;
import com.lowagie.text.pdf.PdfPTable;

import fr.shortcircuit.tp9.model.Product;
import fr.shortcircuit.tp9.service.reporting.definition.AbstractDocumentWriter;
import fr.shortcircuit.tp9.service.reporting.definition.IProductReportWriter;

/** @author Dimitri Dean DARSEYNE (D3), 
 * Published by Short-Circuit under Creative Commons (CC) Licensing: 
 * Authorship/Paternity, NO Commercial Use, NO Derivative
 * Please check for more informations:
 * http://creativecommons.org/licenses/by-nc-nd/2.0/
 *
 * Auteur Dimitri Dean DARSEYNE (D3),
 * Publié par Short-Circuit sous license Creative Commons (CC):
 * Paternité, PAS d'Utilisation Commerciale, pas de Dérivés/Modifications
 * Pour plus d'informations, se rendre sur:
 * http://creativecommons.org/licenses/by-nc-nd/2.0/fr/ 
 * 
 * @since Short-Circuit 1999
 */

//no modification, because of no dependency injection
public class ProductReportAnnotatedWriter extends AbstractDocumentWriter implements IProductReportWriter
{
    private String                          FILE_PATH                   = "./";


    public ProductReportAnnotatedWriter()        {}

    
    //for Web side
    public InputStream generate(List<Product> listProduct) throws Exception
    {
        ByteArrayOutputStream buffer            = new ByteArrayOutputStream(1024);
        
        startDocument(buffer, PageSize.A4.rotate());
        
        document.open();
        publish(listProduct);
        //document.newPage();
        
        endDocument(document);
        buffer.close();
        
        return new ByteArrayInputStream(buffer.toByteArray());
    }
    
    public void publish(List<Product> listProduct)
    {
        try
        {
            addNewParagraph("\r\n\r\nExport des produits", fontBigBold, document, new Integer(Element.ALIGN_CENTER));           

            addNewParagraph("\r\n\r\nListe:", fontMedium, document, new Integer(Element.ALIGN_LEFT));           

            PdfPTable t0     = getNewDefaultPTable(4);

            t0.setTotalWidth(new float[] {60, 10, 20, 10});

            for (Product p : listProduct)
            {
            	addCellToTable(t0, "Product: " 	+ p.getDesignation(),	fontPlainBold,  new Integer(Element.ALIGN_LEFT), 0);
            	addCellToTable(t0, "prix: " 	+ p.getStrPrice(),  	fontPlain,      new Integer(Element.ALIGN_LEFT), 0);
            	addCellToTable(t0, "genre: " 	+ p.getGenre(),         fontPlain,      new Integer(Element.ALIGN_LEFT), 0);
            	addCellToTable(t0, "type: " 	+ p.getType(),        	fontPlain,      new Integer(Element.ALIGN_LEFT), 0);
            }

            addTableToContainer(t0, document);
            addNewParagraph("\r\n", fontPlain, document);
        }
        catch (Exception e) {e.printStackTrace();}        
    }
}
