package fr.shortcircuit.tp9.service.dao.definition;

import java.util.Comparator;
import java.util.List;

import org.apache.commons.collections.Predicate;

import fr.shortcircuit.tp9.model.Product;

/** @author Dimitri Dean DARSEYNE (D3), 
 * Published by Short-Circuit under Creative Commons (CC) Licensing: 
 * Authorship/Paternity, NO Commercial Use, NO Derivative
 * Please check for more informations:
 * http://creativecommons.org/licenses/by-nc-nd/2.0/
 *
 * Auteur Dimitri Dean DARSEYNE (D3),
 * Publié par Short-Circuit sous license Creative Commons (CC):
 * Paternité, PAS d'Utilisation Commerciale, pas de Dérivés/Modifications
 * Pour plus d'informations, se rendre sur:
 * http://creativecommons.org/licenses/by-nc-nd/2.0/fr/ 
 * 
 * @since Short-Circuit 1999
 */

public interface IProductDAO
{

	public Product 			getProduct(Predicate predicate);
	public List<Product> 	getAllProduct(Predicate predicate);
	public List<Product> 	getAllProduct(Comparator beanComparator);
	public List<Product> 	getAllProduct(Comparator beanComparator, int rowIndex, int rowCount);
	public List<Product> 	getAllProduct(Comparator beanComparator, Predicate allPredicateFilters, int rowIndex, int rowCount);
	public int 				count(Predicate allPredicateFilters);
	public List<Product> 	getList();
	public List<String> 	getListGenre();
	public List<String> 	getListPrice();
	
}
