package fr.shortcircuit.tp9.model;

import java.math.BigDecimal;

/** @author Dimitri Dean DARSEYNE (D3), 
 * Published by Short-Circuit under Creative Commons (CC) Licensing: 
 * Authorship/Paternity, NO Commercial Use, NO Derivative
 * Please check for more informations:
 * http://creativecommons.org/licenses/by-nc-nd/2.0/
 *
 * Auteur Dimitri Dean DARSEYNE (D3),
 * Publié par Short-Circuit sous license Creative Commons (CC):
 * Paternité, PAS d'Utilisation Commerciale, pas de Dérivés/Modifications
 * Pour plus d'informations, se rendre sur:
 * http://creativecommons.org/licenses/by-nc-nd/2.0/fr/ 
 * 
 * @since Short-Circuit 1999
 */

public class Product implements Comparable
{
	private int 					id, type, annee;

	private BigDecimal 				price;

	//affecte a vierge pour permettre au BeanUtils de trier sur des proprietes non nulles
	private String 					designation 	= "";
	private String 					genre			= "";	
	private String 					realisateur		= "";
	private String 					musique			= "";
	private String 					scenario		= "";
	private String 					provenance		= "";

	

	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//Constructors
	////////////////////////////////////////////////////////////////////////////////////////////////////////////

	public Product()		{}	

	public Product(int id, String designation, int type, BigDecimal price)
	{
		createStructure(id, designation, type, price);	
	}

	public Product(int id, String designation, int type, BigDecimal price, String genre, String realisateur, int annee)
	{
		createStructure(id, designation, type, price, genre, realisateur, annee);	
	}

	public Product(int id, String designation, int type, BigDecimal price, String genre, String realisateur, int annee, String musique, String scenario)
	{
		createStructure(id, designation, type, price, genre, realisateur, annee, musique, scenario);	
	}

	public void createStructure(int id, String designation, int type, BigDecimal price)
	{
		this.id					= id;
		this.designation		= designation;		   
		this.type				= type;
		this.price				= price;	
	}

	public void createStructure(int id, String designation, int type, BigDecimal price, String genre, String realisateur, int annee)
	{
		this.id					= id;
		this.designation		= designation;		   
		this.type				= type;
		this.price				= price;	
		this.genre				= genre;
		this.realisateur		= realisateur;
		this.annee				= annee;
	}

	public void createStructure(int id, String designation, int type, BigDecimal price, String genre, String realisateur, int annee, String musique, String scenario)
	{
		this.id					= id;
		this.designation		= designation;		   
		this.type				= type;
		this.price				= price;	
		this.genre				= genre;
		this.realisateur		= realisateur;
		this.annee				= annee;
		this.musique			= musique;
		this.scenario			= scenario;
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//Getter and setter
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	
	public int getId()									{return id;}
	public String getDesignation()						{return designation;}
	public int getType()								{return type;}
	public BigDecimal getPrice()					    {return price;}
	public String getStrPrice()					    	{return price.toString();}
	public String getGenre()							{return genre;}
	public String getRealisateur()						{return realisateur;}
	public int getAnnee()								{return annee;}
	public String getMusique()							{return musique;}
	public String getScenario()							{return scenario;}
	public String getProvenance()						{return provenance;}
	
	public void setId(int id)							{this.id				= id;}
	public void setDesignation(String designation)		{this.designation		= designation;}
	public void setType(int type)						{this.type				= type;}
	public void setPrice(BigDecimal price)				{this.price				= price;}
	public void setGenre(String genre)					{this.genre				= genre;}
	public void setRealisateur(String realisateur)		{this.realisateur		= realisateur;}
	public void setAnnee(int annee)						{this.annee				= annee;}
	public void setMusique(String musique)				{this.musique			= musique;}
	public void setScenario(String scenario)			{this.scenario			= scenario;}
	public void setProvenance(String provenance)		{this.provenance		= provenance;}

	//override java.lang.Object method 
	public String toString()							{return designation;}

	/**
	 * 4 Comparable
	 */ 
	public int compareTo(Object o)
	{
		if (! (o instanceof Product))
			throw new ClassCastException("compareTo Product only");

		return designation.compareTo((((Product) o).designation));	

		//return Id.compareTo((((Product) o).Designation));	//Gestion par Id
	}
	
}