package fr.shortcircuit.tp9.business.annotated.automation;

import java.io.InputStream;
import java.util.Comparator;
import java.util.List;

import lombok.Getter;
import lombok.Setter;

import org.apache.commons.collections.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

import fr.shortcircuit.tp9.business.definition.IProductBO;
import fr.shortcircuit.tp9.business.exception.ReportingException;
import fr.shortcircuit.tp9.model.Product;
import fr.shortcircuit.tp9.service.dao.definition.IProductDAO;
import fr.shortcircuit.tp9.service.reporting.definition.IProductReportWriter;

/** @author Dimitri Dean DARSEYNE (D3), 
 * Published by Short-Circuit under Creative Commons (CC) Licensing: 
 * Authorship/Paternity, NO Commercial Use, NO Derivative
 * Please check for more informations:
 * http://creativecommons.org/licenses/by-nc-nd/2.0/
 *
 * Auteur Dimitri Dean DARSEYNE (D3),
 * Publié par Short-Circuit sous license Creative Commons (CC):
 * Paternité, PAS d'Utilisation Commerciale, pas de Dérivés/Modifications
 * Pour plus d'informations, se rendre sur:
 * http://creativecommons.org/licenses/by-nc-nd/2.0/fr/ 
 * 
 * @since Short-Circuit 1999
 */

@Service("productBO")
@Scope("session")
public class ProductAnnotatedAutomationBO implements IProductBO
{
	@Autowired(required=true) //Spring annotation to declare the property auto-wiring 
	@Getter @Setter
	private IProductDAO 			productDAO;

	@Autowired(required=true) //Spring annotation to declare the property auto-wiring 
	@Getter @Setter
	private IProductReportWriter	reportWriter;
	
	
	public ProductAnnotatedAutomationBO() {}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//Services access
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////
	
	//The BO instance is acting like a Facade, it hides the invocation complexity, 
	//and manage the conversion of technical exceptions (not relevant for end user) in business exceptions (more concrete for end user)
	public InputStream getPDF(Comparator beanComparator) throws ReportingException 
	{
		try {return reportWriter.generate(getAllProduct(beanComparator));}
		catch (Exception e) {throw new ReportingException("Exception has happened during reporting generation !");}
	}

	public List<Product> getList()																	{return productDAO.getList();};
	public List<String> getListGenre() 																{return productDAO.getListGenre();}
	public List<String> getListPrice() 																{return productDAO.getListPrice();}
	public Product getProduct(Predicate predicate)													{return productDAO.getProduct(predicate);}
	public List<Product> getAllProduct(Predicate predicate)											{return productDAO.getAllProduct(predicate);}
	public List<Product> getAllProduct(Comparator beanComparator)									{return productDAO.getAllProduct(beanComparator);}
	public List<Product> getAllProduct(Comparator beanComparator, int rowIndex, int rowCount)		{return productDAO.getAllProduct(beanComparator, rowIndex, rowCount);}
	public List<Product> getAllProduct(Comparator c, Predicate filters, int rowIndex, int rowCount) {return productDAO.getAllProduct(c, filters, rowIndex, rowCount);}
	public int count(Predicate allPredicateFilters)													{return productDAO.count(allPredicateFilters);}
}
