/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.timeline;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.primefaces.context.RequestContext;
import org.primefaces.extensions.component.timeline.Timeline;
import org.primefaces.extensions.component.timeline.TimelineRenderer;
import org.primefaces.extensions.component.timeline.TimelineUpdater;
import org.primefaces.extensions.model.timeline.TimelineEvent;
import org.primefaces.extensions.model.timeline.TimelineGroup;
import org.primefaces.extensions.util.ComponentUtils;
import org.primefaces.extensions.util.FastStringWriter;

public class DefaultTimelineUpdater
extends TimelineUpdater
implements PhaseListener {
    private static final long serialVersionUID = 20130317L;
    private static final Logger LOG = Logger.getLogger(DefaultTimelineUpdater.class.getName());
    private String widgetVar;
    private List<CrudOperationData> crudOperationDatas;

    public void add(TimelineEvent event) {
        if (event == null) {
            return;
        }
        this.checkCrudOperationDataList();
        this.crudOperationDatas.add(new CrudOperationData(CrudOperation.ADD, event));
    }

    public void update(TimelineEvent event, int index) {
        if (event == null) {
            return;
        }
        this.checkCrudOperationDataList();
        this.crudOperationDatas.add(new CrudOperationData(CrudOperation.UPDATE, event, index));
    }

    public void delete(int index) {
        this.checkCrudOperationDataList();
        this.crudOperationDatas.add(new CrudOperationData(CrudOperation.DELETE, index));
    }

    public void select(int index) {
        this.checkCrudOperationDataList();
        this.crudOperationDatas.add(new CrudOperationData(CrudOperation.SELECT, index));
    }

    public void clear() {
        this.checkCrudOperationDataList();
        this.crudOperationDatas.add(new CrudOperationData(CrudOperation.CLEAR));
    }

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }

    public void beforePhase(PhaseEvent event) {
        if (this.crudOperationDatas == null) {
            return;
        }
        FacesContext fc = event.getFacesContext();
        StringBuilder sb = new StringBuilder();
        FastStringWriter fsw = new FastStringWriter();
        FastStringWriter fswHtml = new FastStringWriter();
        Timeline timeline = (Timeline)fc.getViewRoot().findComponent(this.id);
        TimelineRenderer timelineRenderer = (TimelineRenderer)fc.getRenderKit().getRenderer("org.primefaces.extensions.component", "org.primefaces.extensions.component.TimelineRenderer");
        HashMap<String, String> groupsContent = null;
        List<TimelineGroup> groups = timeline.getValue().getGroups();
        UIComponent groupFacet = timeline.getFacet("group");
        if (groups != null && groupFacet != null) {
            groupsContent = new HashMap<String, String>();
        }
        TimeZone targetTZ = ComponentUtils.resolveTimeZone(timeline.getTimeZone());
        TimeZone browserTZ = ComponentUtils.resolveTimeZone(timeline.getBrowserTimeZone());
        try {
            for (CrudOperationData crudOperationData : this.crudOperationDatas) {
                switch (crudOperationData.getCrudOperation()) {
                    case ADD: {
                        sb.append(";PF('");
                        sb.append(this.widgetVar);
                        sb.append("').addEvent(");
                        sb.append(timelineRenderer.encodeEvent(fc, fsw, fswHtml, timeline, browserTZ, targetTZ, groups, groupFacet, groupsContent, crudOperationData.getEvent()));
                        sb.append(")");
                        break;
                    }
                    case UPDATE: {
                        sb.append(";PF('");
                        sb.append(this.widgetVar);
                        sb.append("').changeEvent(");
                        sb.append(crudOperationData.getIndex());
                        sb.append(",");
                        sb.append(timelineRenderer.encodeEvent(fc, fsw, fswHtml, timeline, browserTZ, targetTZ, groups, groupFacet, groupsContent, crudOperationData.getEvent()));
                        sb.append(")");
                        break;
                    }
                    case DELETE: {
                        sb.append(";PF('");
                        sb.append(this.widgetVar);
                        sb.append("').deleteEvent(");
                        sb.append(crudOperationData.getIndex());
                        sb.append(")");
                        break;
                    }
                    case SELECT: {
                        sb.append(";PF('");
                        sb.append(this.widgetVar);
                        sb.append("').setSelection(");
                        sb.append(crudOperationData.getIndex());
                        sb.append(")");
                        break;
                    }
                    case CLEAR: {
                        sb.append(";PF('");
                        sb.append(this.widgetVar);
                        sb.append("').deleteAllEvents()");
                    }
                }
            }
            RequestContext.getCurrentInstance().execute(sb.toString());
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Timeline with id " + this.id + " could not be updated, at least one CRUD operation failed", e);
        }
    }

    public void afterPhase(PhaseEvent event) {
    }

    public void setWidgetVar(String widgetVar) {
        this.widgetVar = widgetVar;
    }

    private void checkCrudOperationDataList() {
        if (this.crudOperationDatas == null) {
            this.crudOperationDatas = new ArrayList<CrudOperationData>();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultTimelineUpdater that = (DefaultTimelineUpdater)o;
        return !(this.widgetVar != null ? !this.widgetVar.equals(that.widgetVar) : that.widgetVar != null);
    }

    public int hashCode() {
        return this.widgetVar != null ? this.widgetVar.hashCode() : 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CrudOperation {
        ADD,
        UPDATE,
        DELETE,
        SELECT,
        CLEAR;

    }

    class CrudOperationData
    implements Serializable {
        private CrudOperation crudOperation;
        private TimelineEvent event;
        private int index;

        CrudOperationData(CrudOperation crudOperation) {
            this.crudOperation = crudOperation;
        }

        CrudOperationData(CrudOperation crudOperation, TimelineEvent event) {
            this.crudOperation = crudOperation;
            this.event = event;
        }

        CrudOperationData(CrudOperation crudOperation, int index) {
            this.crudOperation = crudOperation;
            this.index = index;
        }

        CrudOperationData(CrudOperation crudOperation, TimelineEvent event, int index) {
            this.crudOperation = crudOperation;
            this.event = event;
            this.index = index;
        }

        public CrudOperation getCrudOperation() {
            return this.crudOperation;
        }

        public TimelineEvent getEvent() {
            return this.event;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

