/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.remotecommand;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.primefaces.extensions.component.base.AbstractParameter;
import org.primefaces.extensions.component.parameters.AssignableParameter;
import org.primefaces.extensions.component.remotecommand.RemoteCommand;
import org.primefaces.extensions.util.ComponentUtils;
import org.primefaces.extensions.util.ExtAjaxRequestBuilder;
import org.primefaces.renderkit.CoreRenderer;

public class RemoteCommandRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        String clientId;
        RemoteCommand command = (RemoteCommand)component;
        Map params = context.getExternalContext().getRequestParameterMap();
        if (params.containsKey(clientId = command.getClientId(context))) {
            ActionEvent event = new ActionEvent((UIComponent)command);
            if (command.isImmediate()) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
            ELContext elContext = context.getELContext();
            for (AssignableParameter param : command.getAssignableParameters()) {
                if (!param.isRendered()) continue;
                ValueExpression valueExpression = param.getAssignTo();
                String paramValue = (String)params.get(clientId + "_" + param.getName());
                Converter converter = param.getConverter();
                if (converter != null) {
                    Object convertedValue = converter.getAsObject(context, (UIComponent)param, paramValue);
                    valueExpression.setValue(elContext, convertedValue);
                    continue;
                }
                valueExpression.setValue(elContext, (Object)paramValue);
            }
            command.queueEvent((FacesEvent)event);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        RemoteCommand command;
        UIComponent form = ComponentUtils.findParentForm((FacesContext)context, (UIComponent)component);
        if (form == null) {
            throw new FacesException("Component " + component.getClientId(context) + " must be enclosed in a form.");
        }
        ResponseWriter writer = context.getResponseWriter();
        RemoteCommand source = command = (RemoteCommand)component;
        String clientId = command.getClientId(context);
        List<AbstractParameter> parameters = command.getAllParameters();
        String name = command.getName();
        ExtAjaxRequestBuilder builder = ExtAjaxRequestBuilder.get(context);
        builder.init().source(clientId).form(form.getClientId(context)).process(component, source.getProcess()).update(component, source.getUpdate()).async(source.isAsync()).global(source.isGlobal()).partialSubmit(source.isPartialSubmit(), command.isPartialSubmitSet()).resetValues(source.isResetValues(), source.isResetValuesSet()).ignoreAutoUpdate(source.isIgnoreAutoUpdate()).onstart(source.getOnstart()).onerror(source.getOnerror()).onsuccess(source.getOnsuccess()).oncomplete(source.getOncomplete()).delay(source.getDelay());
        builder.params(clientId, parameters);
        String request = builder.build();
        writer.startElement("script", (UIComponent)command);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeAttribute("id", (Object)command.getClientId(), null);
        writer.write(name + " = function(");
        for (int i = 0; i < parameters.size(); ++i) {
            if (i != 0) {
                writer.write(",");
            }
            AbstractParameter param = parameters.get(i);
            writer.write(param.getName());
        }
        writer.write(") {");
        writer.write(request);
        writer.write("}");
        if (command.isAutoRun()) {
            writer.write(";$(function() {");
            writer.write(name + "();");
            writer.write("});");
        }
        writer.endElement("script");
    }
}

