/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.masterdetail;

import java.io.Serializable;
import java.util.Map;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.PostRestoreStateEvent;
import org.apache.commons.lang3.StringUtils;
import org.primefaces.component.breadcrumb.BreadCrumb;
import org.primefaces.extensions.component.masterdetail.MasterDetailLevel;
import org.primefaces.model.menu.DefaultMenuItem;
import org.primefaces.model.menu.MenuElement;
import org.primefaces.model.menu.MenuModel;

@ResourceDependency(library="primefaces-extensions", name="primefaces-extensions.css")
public class MasterDetail
extends UIComponentBase {
    public static final String COMPONENT_TYPE = "org.primefaces.extensions.component.MasterDetail";
    public static final String COMPONENT_FAMILY = "org.primefaces.extensions.component";
    private static final String DEFAULT_RENDERER = "org.primefaces.extensions.component.MasterDetailRenderer";
    public static final String CONTEXT_VALUE_VALUE_EXPRESSION = "mdContextValueVE";
    public static final String SELECTED_LEVEL_VALUE_EXPRESSION = "selectedLevelVE";
    public static final String SELECTED_STEP_VALUE_EXPRESSION = "selectedStepVE";
    public static final String PRESERVE_INPUTS_VALUE_EXPRESSION = "preserveInputsVE";
    public static final String RESET_INPUTS_VALUE_EXPRESSION = "resetInputsVE";
    public static final String CONTEXT_VALUES = "mdContextValues";
    public static final String SELECT_DETAIL_REQUEST = "_selectDetailRequest";
    public static final String CURRENT_LEVEL = "_currentLevel";
    public static final String SELECTED_LEVEL = "_selectedLevel";
    public static final String SELECTED_STEP = "_selectedStep";
    public static final String PRESERVE_INPUTS = "_preserveInputs";
    public static final String RESET_INPUTS = "_resetInputs";
    public static final String CURRENT_CONTEXT_VALUE = "_curContextValue";
    public static final String RESOLVED_CONTEXT_VALUE = "contextValue_";
    public static final String BREADCRUMB_ID_PREFIX = "_bc";
    private MasterDetailLevel detailLevelToProcess;
    private MasterDetailLevel detailLevelToGo;
    private int levelPositionToProcess = -1;
    private int levelCount = -1;

    public MasterDetail() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public int getLevel() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.level), (Object)1);
    }

    public void setLevel(int level) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.level), (Object)level);
    }

    public Object getContextValue() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.contextValue), null);
    }

    public void setContextValue(Object contextValue) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.contextValue), contextValue);
    }

    public MethodExpression getSelectLevelListener() {
        return (MethodExpression)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.selectLevelListener), null);
    }

    public void setSelectLevelListener(MethodExpression selectLevelListener) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.selectLevelListener), (Object)selectLevelListener);
    }

    public boolean isShowBreadcrumb() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showBreadcrumb), (Object)true);
    }

    public void setShowBreadcrumb(boolean showBreadcrumb) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showBreadcrumb), (Object)showBreadcrumb);
    }

    public boolean isShowAllBreadcrumbItems() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showAllBreadcrumbItems), (Object)false);
    }

    public void setShowAllBreadcrumbItems(boolean showAllBreadcrumbItems) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showAllBreadcrumbItems), (Object)showAllBreadcrumbItems);
    }

    public boolean isBreadcrumbAboveHeader() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.breadcrumbAboveHeader), (Object)true);
    }

    public void setBreadcrumbAboveHeader(boolean breadcrumbAboveHeader) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.breadcrumbAboveHeader), (Object)breadcrumbAboveHeader);
    }

    public String getStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.style), null);
    }

    public void setStyle(String style) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.style), (Object)style);
    }

    public String getStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClass), null);
    }

    public void setStyleClass(String styleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleClass), (Object)styleClass);
    }

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        super.processEvent(event);
        FacesContext fc = FacesContext.getCurrentInstance();
        if (!(event instanceof PostRestoreStateEvent) || !this.isSelectDetailRequest(fc)) {
            return;
        }
        PartialViewContext pvc = fc.getPartialViewContext();
        if (pvc.getRenderIds().isEmpty()) {
            pvc.getRenderIds().add(this.getClientId(fc));
        }
        MasterDetailLevel mdl = this.getDetailLevelToProcess(fc);
        Object contextValue = this.getContextValueFromFlow(fc, mdl, true);
        String contextVar = mdl.getContextVar();
        if (StringUtils.isNotBlank((CharSequence)contextVar) && contextValue != null) {
            Map requestMap = fc.getExternalContext().getRequestMap();
            requestMap.put(contextVar, contextValue);
        }
    }

    public void processDecodes(FacesContext fc) {
        if (!this.isSelectDetailRequest(fc)) {
            super.processDecodes(fc);
        } else {
            this.getDetailLevelToProcess(fc).processDecodes(fc);
        }
    }

    public void processValidators(FacesContext fc) {
        if (!this.isSelectDetailRequest(fc)) {
            super.processValidators(fc);
        } else {
            this.getDetailLevelToProcess(fc).processValidators(fc);
        }
    }

    public void processUpdates(FacesContext fc) {
        if (!this.isSelectDetailRequest(fc)) {
            super.processUpdates(fc);
        } else {
            this.getDetailLevelToProcess(fc).processUpdates(fc);
        }
    }

    public MasterDetailLevel getDetailLevelToProcess(FacesContext fc) {
        if (this.detailLevelToProcess == null) {
            this.initDataForLevels(fc);
        }
        return this.detailLevelToProcess;
    }

    public MasterDetailLevel getDetailLevelToGo(FacesContext fc) {
        if (this.detailLevelToGo != null) {
            return this.detailLevelToGo;
        }
        String strSelectedLevel = (String)fc.getExternalContext().getRequestParameterMap().get(this.getClientId(fc) + SELECTED_LEVEL);
        String strSelectedStep = (String)fc.getExternalContext().getRequestParameterMap().get(this.getClientId(fc) + SELECTED_STEP);
        if (strSelectedLevel != null) {
            int selectedLevel = Integer.valueOf(strSelectedLevel);
            this.detailLevelToGo = this.getDetailLevelByLevel(selectedLevel);
            if (this.detailLevelToGo != null) {
                return this.detailLevelToGo;
            }
            throw new FacesException("MasterDetailLevel for selected level = " + selectedLevel + " not found.");
        }
        int step = strSelectedStep != null ? Integer.valueOf(strSelectedStep) : 1;
        this.detailLevelToGo = this.getDetailLevelByStep(step);
        return this.detailLevelToGo;
    }

    public MasterDetailLevel getDetailLevelByLevel(int level) {
        for (UIComponent child : this.getChildren()) {
            MasterDetailLevel mdl;
            if (!(child instanceof MasterDetailLevel) || (mdl = (MasterDetailLevel)child).getLevel() != level) continue;
            return mdl;
        }
        return null;
    }

    public boolean isSelectDetailRequest(FacesContext fc) {
        return fc.getPartialViewContext().isAjaxRequest() && fc.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(fc) + SELECT_DETAIL_REQUEST);
    }

    public String getPreserveInputs(FacesContext fc) {
        return (String)fc.getExternalContext().getRequestParameterMap().get(this.getClientId(fc) + PRESERVE_INPUTS);
    }

    public String getResetInputs(FacesContext fc) {
        return (String)fc.getExternalContext().getRequestParameterMap().get(this.getClientId(fc) + RESET_INPUTS);
    }

    public void updateModel(FacesContext fc, MasterDetailLevel mdlToGo) {
        int levelToGo = mdlToGo.getLevel();
        ValueExpression levelVE = this.getValueExpression(PropertyKeys.level.toString());
        if (levelVE != null) {
            levelVE.setValue(fc.getELContext(), (Object)levelToGo);
            this.getStateHelper().remove((Serializable)((Object)PropertyKeys.level));
        }
        String source = (String)fc.getExternalContext().getRequestParameterMap().get("javax.faces.source");
        MasterDetailLevel mdl = this.getDetailLevelToProcess(fc);
        Object contextValue = null;
        Map contextValues = (Map)mdl.getAttributes().get(CONTEXT_VALUES);
        if (contextValues != null) {
            contextValue = contextValues.get(RESOLVED_CONTEXT_VALUE + source);
        }
        if (contextValue != null) {
            mdlToGo.getAttributes().put(this.getClientId(fc) + CURRENT_CONTEXT_VALUE, contextValue);
            ValueExpression contextValueVE = this.getValueExpression(PropertyKeys.contextValue.toString());
            if (contextValueVE != null) {
                contextValueVE.setValue(fc.getELContext(), contextValue);
                this.getStateHelper().remove((Serializable)((Object)PropertyKeys.contextValue));
            }
        }
    }

    public Object getContextValueFromFlow(FacesContext fc, MasterDetailLevel mdl, boolean includeModel) {
        Object contextValue = mdl.getAttributes().get(this.getClientId(fc) + CURRENT_CONTEXT_VALUE);
        if (contextValue != null) {
            return contextValue;
        }
        if (includeModel) {
            return this.getContextValue();
        }
        return null;
    }

    public BreadCrumb getBreadcrumb() {
        MenuModel model;
        BreadCrumb breadCrumb = null;
        for (UIComponent child : this.getChildren()) {
            if (!(child instanceof BreadCrumb)) continue;
            breadCrumb = (BreadCrumb)child;
            break;
        }
        MenuModel menuModel = model = breadCrumb != null ? breadCrumb.getModel() : null;
        if (model != null && model.getElements().isEmpty()) {
            String clientId = this.getClientId();
            String menuItemIdPrefix = this.getId() + "_bcItem_";
            for (UIComponent child : this.getChildren()) {
                if (!(child instanceof MasterDetailLevel)) continue;
                int level = ((MasterDetailLevel)child).getLevel();
                DefaultMenuItem menuItem = new DefaultMenuItem();
                menuItem.setId(menuItemIdPrefix + level);
                menuItem.setAjax(true);
                menuItem.setImmediate(true);
                menuItem.setProcess("@none");
                menuItem.setUpdate("@parent");
                menuItem.setParam(clientId + SELECT_DETAIL_REQUEST, (Object)true);
                menuItem.setParam(clientId + CURRENT_LEVEL, (Object)-1);
                menuItem.setParam(clientId + SELECTED_LEVEL, (Object)level);
                model.addElement((MenuElement)menuItem);
            }
        }
        return breadCrumb;
    }

    public void resetCalculatedValues() {
        this.detailLevelToProcess = null;
        this.detailLevelToGo = null;
        this.levelPositionToProcess = -1;
        this.levelCount = -1;
    }

    private void initDataForLevels(FacesContext fc) {
        String strCurrentLevel = (String)fc.getExternalContext().getRequestParameterMap().get(this.getClientId(fc) + CURRENT_LEVEL);
        if (strCurrentLevel == null) {
            throw new FacesException("Current level is missing in request.");
        }
        int currentLevel = Integer.valueOf(strCurrentLevel);
        int count = 0;
        for (UIComponent child : this.getChildren()) {
            if (!(child instanceof MasterDetailLevel)) continue;
            MasterDetailLevel mdl = (MasterDetailLevel)child;
            ++count;
            if (this.detailLevelToProcess != null || mdl.getLevel() != currentLevel) continue;
            this.detailLevelToProcess = mdl;
            this.levelPositionToProcess = count;
        }
        this.levelCount = count;
        if (this.detailLevelToProcess == null) {
            throw new FacesException("Current MasterDetailLevel to process not found.");
        }
    }

    private MasterDetailLevel getDetailLevelByStep(int step) {
        int levelPositionToGo = this.getLevelPositionToProcess() + step;
        if (levelPositionToGo < 1) {
            levelPositionToGo = 1;
        } else if (levelPositionToGo > this.getLevelCount()) {
            levelPositionToGo = this.getLevelCount();
        }
        int pos = 0;
        for (UIComponent child : this.getChildren()) {
            if (!(child instanceof MasterDetailLevel)) continue;
            MasterDetailLevel mdl = (MasterDetailLevel)child;
            if (++pos != levelPositionToGo) continue;
            return mdl;
        }
        return null;
    }

    private int getLevelPositionToProcess() {
        if (this.levelPositionToProcess == -1) {
            this.initDataForLevels(FacesContext.getCurrentInstance());
        }
        return this.levelPositionToProcess;
    }

    private int getLevelCount() {
        if (this.levelCount == -1) {
            this.initDataForLevels(FacesContext.getCurrentInstance());
        }
        return this.levelCount;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PropertyKeys {
        level,
        contextValue,
        selectLevelListener,
        showBreadcrumb,
        showAllBreadcrumbItems,
        breadcrumbAboveHeader,
        style,
        styleClass;

        private String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

