/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.exporter;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.el.MethodExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.component.html.HtmlCommandButton;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.WorkbookUtil;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.column.Column;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.datalist.DataList;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.rowexpansion.RowExpansion;
import org.primefaces.component.subtable.SubTable;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.extensions.component.exporter.Exporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelExporter
extends Exporter {
    private CellStyle cellStyle;
    private CellStyle facetStyle;
    private CellStyle titleStyle;
    private Color facetBackground;
    private Short facetFontSize;
    private Color facetFontColor;
    private String facetFontStyle;
    private String fontName;
    private Short cellFontSize;
    private Color cellFontColor;
    private String cellFontStyle;
    private String datasetPadding;
    private CellStyle facetStyleLeftAlign;
    private CellStyle facetStyleCenterAlign;
    private CellStyle facetStyleRightAlign;
    private CellStyle cellStyleLeftAlign;
    private CellStyle cellStyleCenterAlign;
    private CellStyle cellStyleRightAlign;
    XSSFWorkbook wb;

    @Override
    public void export(ActionEvent event, String tableId, FacesContext context, String filename, String tableTitle, boolean pageOnly, boolean selectionOnly, String encodingType, MethodExpression preProcessor, MethodExpression postProcessor, boolean subTable) throws IOException {
        this.wb = new XSSFWorkbook();
        String safeName = WorkbookUtil.createSafeSheetName((String)filename);
        XSSFSheet sheet = this.wb.createSheet(safeName);
        this.cellStyle = this.wb.createCellStyle();
        this.facetStyle = this.wb.createCellStyle();
        this.titleStyle = this.wb.createCellStyle();
        this.facetStyleLeftAlign = this.wb.createCellStyle();
        this.facetStyleCenterAlign = this.wb.createCellStyle();
        this.facetStyleRightAlign = this.wb.createCellStyle();
        this.cellStyleLeftAlign = this.wb.createCellStyle();
        this.cellStyleCenterAlign = this.wb.createCellStyle();
        this.cellStyleRightAlign = this.wb.createCellStyle();
        this.createCustomFonts();
        int maxColumns = 0;
        StringTokenizer st = new StringTokenizer(tableId, ",");
        while (st.hasMoreElements()) {
            String tableName = (String)st.nextElement();
            UIComponent component = SearchExpressionFacade.resolveComponent((FacesContext)context, (UIComponent)event.getComponent(), (String)tableName);
            if (component == null) {
                throw new FacesException("Cannot find component \"" + tableName + "\" in view.");
            }
            if (!(component instanceof DataTable) && !(component instanceof DataList)) {
                throw new FacesException("Unsupported datasource target:\"" + component.getClass().getName() + "\", exporter must target a PrimeFaces DataTable/DataList.");
            }
            DataList list = null;
            DataTable table = null;
            int cols = 0;
            if (preProcessor != null) {
                preProcessor.invoke(context.getELContext(), new Object[]{this.wb});
            }
            if (tableTitle != null && !tableTitle.isEmpty() && !tableId.contains(",")) {
                Row titleRow = sheet.createRow(sheet.getLastRowNum());
                short cellIndex = titleRow.getLastCellNum() == -1 ? (short)0 : titleRow.getLastCellNum();
                Cell cell = titleRow.createCell((int)cellIndex);
                cell.setCellValue((RichTextString)new XSSFRichTextString(tableTitle));
                XSSFFont titleFont = this.wb.createFont();
                titleFont.setBoldweight((short)700);
                this.titleStyle.setFont((Font)titleFont);
                cell.setCellStyle(this.titleStyle);
                sheet.createRow(sheet.getLastRowNum() + 3);
            }
            if (component instanceof DataList) {
                list = (DataList)component;
                if (list.getHeader() != null) {
                    this.tableFacet(context, (Sheet)sheet, list, "header");
                }
                if (pageOnly) {
                    this.exportPageOnly(context, list, (Sheet)sheet);
                } else {
                    this.exportAll(context, list, (Sheet)sheet);
                }
                cols = list.getRowCount();
            } else {
                table = (DataTable)component;
                int columnsCount = this.getColumnsCount(table);
                if (table.getHeader() != null && !subTable) {
                    this.tableFacet(context, (Sheet)sheet, table, columnsCount, "header");
                }
                if (!subTable) {
                    this.tableColumnGroup((Sheet)sheet, table, "header");
                }
                this.addColumnFacets(table, (Sheet)sheet, Exporter.ColumnType.HEADER);
                if (pageOnly) {
                    this.exportPageOnly(context, table, (Sheet)sheet);
                } else if (selectionOnly) {
                    this.exportSelectionOnly(context, table, (Sheet)sheet);
                } else {
                    this.exportAll(context, table, (Sheet)sheet, subTable);
                }
                if (table.hasFooterColumn() && !subTable) {
                    this.addColumnFacets(table, (Sheet)sheet, Exporter.ColumnType.FOOTER);
                }
                if (!subTable) {
                    this.tableColumnGroup((Sheet)sheet, table, "footer");
                }
                table.setRowIndex(-1);
                if (postProcessor != null) {
                    postProcessor.invoke(context.getELContext(), new Object[]{this.wb});
                }
                if (maxColumns < (cols = table.getColumnsCount())) {
                    maxColumns = cols;
                }
            }
            sheet.createRow(sheet.getLastRowNum() + Integer.parseInt(this.datasetPadding));
        }
        if (!subTable) {
            for (int i = 0; i < maxColumns; ++i) {
                sheet.autoSizeColumn((int)((short)i));
            }
        }
        PrintSetup printSetup = sheet.getPrintSetup();
        printSetup.setLandscape(true);
        printSetup.setPaperSize((short)9);
        sheet.setPrintGridlines(true);
        this.writeExcelToResponse(context.getExternalContext(), (Workbook)this.wb, filename);
    }

    protected void exportAll(FacesContext context, DataTable table, Sheet sheet, Boolean subTable) {
        int first = table.getFirst();
        int rowCount = table.getRowCount();
        int rows = table.getRows();
        boolean lazy = table.isLazy();
        int i = 0;
        if (subTable.booleanValue()) {
            int subTableCount = table.getRowCount();
            SubTable subtable = table.getSubTable();
            int subTableColumnsCount = this.getColumnsCount(subtable);
            if (table.getHeader() != null) {
                this.tableFacet(context, sheet, table, subTableColumnsCount, "header");
            }
            this.tableColumnGroup(sheet, table, "header");
            while (subTableCount > 0) {
                --subTableCount;
                table.setRowIndex(i);
                ++i;
                if (subtable.getHeader() != null) {
                    this.tableFacet(context, sheet, subtable, subTableColumnsCount, "header");
                }
                if (this.hasHeaderColumn(subtable)) {
                    this.addColumnFacets(subtable, sheet, Exporter.ColumnType.HEADER);
                }
                this.exportAll(context, subtable, sheet);
                if (this.hasFooterColumn(subtable)) {
                    this.addColumnFacets(subtable, sheet, Exporter.ColumnType.FOOTER);
                }
                if (subtable.getFooter() != null) {
                    this.tableFacet(context, sheet, subtable, subTableColumnsCount, "footer");
                }
                subtable.setRowIndex(-1);
                subtable = table.getSubTable();
            }
            this.tableColumnGroup(sheet, table, "footer");
            if (table.hasFooterColumn()) {
                this.tableFacet(context, sheet, table, subTableColumnsCount, "footer");
            }
        } else if (lazy) {
            if (rowCount > 0) {
                table.setFirst(0);
                table.setRows(rowCount);
                table.clearLazyCache();
                table.loadLazyData();
            }
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                this.exportRow(table, sheet, rowIndex);
            }
            table.setFirst(first);
            table.setRowIndex(-1);
            table.clearLazyCache();
            table.loadLazyData();
        } else {
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                this.exportRow(table, sheet, rowIndex);
            }
            table.setFirst(first);
        }
    }

    protected void exportAll(FacesContext context, SubTable table, Sheet sheet) {
        int first = table.getFirst();
        int rowCount = table.getRowCount();
        int rows = table.getRows();
        this.tableColumnGroup(sheet, table, "header");
        if (this.hasHeaderColumn(table)) {
            this.addColumnFacets(table, sheet, Exporter.ColumnType.HEADER);
        }
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            this.exportRow(table, sheet, rowIndex);
        }
        if (this.hasFooterColumn(table)) {
            this.addColumnFacets(table, sheet, Exporter.ColumnType.FOOTER);
        }
        this.tableColumnGroup(sheet, table, "footer");
    }

    protected void exportAll(FacesContext context, DataList list, Sheet sheet) {
        int first = list.getFirst();
        int rowCount = list.getRowCount();
        int rows = list.getRows();
        boolean lazy = false;
        if (lazy) {
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                if (rowIndex % rows == 0) {
                    list.setFirst(rowIndex);
                }
                this.exportRow(list, sheet, rowIndex);
            }
            list.setFirst(first);
        } else {
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                this.exportRow(list, sheet, rowIndex);
            }
            list.setFirst(first);
        }
    }

    protected void exportPageOnly(FacesContext context, DataTable table, Sheet sheet) {
        int first = table.getFirst();
        int rowsToExport = first + table.getRows();
        for (int rowIndex = first; rowIndex < rowsToExport; ++rowIndex) {
            this.exportRow(table, sheet, rowIndex);
        }
    }

    protected void exportPageOnly(FacesContext context, DataList list, Sheet sheet) {
        int first = list.getFirst();
        int rowsToExport = first + list.getRows();
        for (int rowIndex = first; rowIndex < rowsToExport; ++rowIndex) {
            this.exportRow(list, sheet, rowIndex);
        }
    }

    protected void exportSelectionOnly(FacesContext context, DataTable table, Sheet sheet) {
        Object selection = table.getSelection();
        String var = table.getVar();
        if (selection != null) {
            Map requestMap = context.getExternalContext().getRequestMap();
            if (selection.getClass().isArray()) {
                int size = Array.getLength(selection);
                for (int i = 0; i < size; ++i) {
                    requestMap.put(var, Array.get(selection, i));
                    this.exportCells(table, sheet);
                }
            } else if (List.class.isAssignableFrom(selection.getClass())) {
                List list = (List)selection;
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    requestMap.put(var, it.next());
                    this.exportCells(table, sheet);
                }
            } else {
                requestMap.put(var, selection);
                this.exportCells(table, sheet);
            }
        }
    }

    protected void tableFacet(FacesContext context, Sheet sheet, DataTable table, int columnCount, String facetType) {
        Map map = table.getFacets();
        UIComponent component = (UIComponent)map.get(facetType);
        if (component != null) {
            String headerValue = null;
            if (component instanceof HtmlCommandButton) {
                headerValue = this.exportValue(context, component);
            } else if (component instanceof HtmlCommandLink) {
                headerValue = this.exportValue(context, component);
            } else if (component instanceof UIPanel) {
                String header = "";
                for (UIComponent child : component.getChildren()) {
                    headerValue = this.exportValue(context, child);
                    header = header + headerValue;
                }
                headerValue = header;
            } else {
                headerValue = this.exportFacetValue(context, component);
            }
            int sheetRowIndex = sheet.getLastRowNum() + 1;
            Row row = sheet.createRow(sheetRowIndex);
            Cell cell = row.createCell(0);
            cell.setCellValue(headerValue);
            cell.setCellStyle(this.facetStyle);
            sheet.addMergedRegion(new CellRangeAddress(sheetRowIndex, sheetRowIndex, 0, columnCount));
        }
    }

    protected void tableFacet(FacesContext context, Sheet sheet, SubTable table, int columnCount, String facetType) {
        Map map = table.getFacets();
        UIComponent component = (UIComponent)map.get(facetType);
        if (component != null) {
            String headerValue = null;
            if (component instanceof HtmlCommandButton) {
                headerValue = this.exportValue(context, component);
            } else if (component instanceof HtmlCommandLink) {
                headerValue = this.exportValue(context, component);
            } else if (component instanceof UIPanel) {
                String header = "";
                for (UIComponent child : component.getChildren()) {
                    headerValue = this.exportValue(context, child);
                    header = header + headerValue;
                }
                headerValue = header;
            } else {
                headerValue = this.exportFacetValue(context, component);
            }
            int sheetRowIndex = sheet.getLastRowNum() + 1;
            Row row = sheet.createRow(sheetRowIndex);
            Cell cell = row.createCell(0);
            cell.setCellValue(headerValue);
            cell.setCellStyle(this.facetStyle);
            sheet.addMergedRegion(new CellRangeAddress(sheetRowIndex, sheetRowIndex, 0, columnCount));
        }
    }

    protected void tableFacet(FacesContext context, Sheet sheet, DataList list, String facetType) {
        Map map = list.getFacets();
        UIComponent component = (UIComponent)map.get(facetType);
        if (component != null) {
            String headerValue = null;
            headerValue = component instanceof HtmlCommandButton ? this.exportValue(context, component) : (component instanceof HtmlCommandLink ? this.exportValue(context, component) : this.exportFacetValue(context, component));
            int sheetRowIndex = sheet.getLastRowNum() + 1;
            Row row = sheet.createRow(sheetRowIndex);
            Cell cell = row.createCell(0);
            cell.setCellValue(headerValue);
            cell.setCellStyle(this.facetStyle);
            sheet.addMergedRegion(new CellRangeAddress(sheetRowIndex, sheetRowIndex, 0, 1));
        }
    }

    protected void tableColumnGroup(Sheet sheet, DataTable table, String facetType) {
        ColumnGroup cg = table.getColumnGroup(facetType);
        List headerComponentList = null;
        if (cg != null) {
            headerComponentList = cg.getChildren();
        }
        if (headerComponentList != null) {
            for (UIComponent component : headerComponentList) {
                if (!(component instanceof org.primefaces.component.row.Row)) continue;
                org.primefaces.component.row.Row row = (org.primefaces.component.row.Row)component;
                int sheetRowIndex = sheet.getLastRowNum() + 1;
                Row xlRow = sheet.createRow(sheetRowIndex);
                int i = 0;
                for (UIComponent rowComponent : row.getChildren()) {
                    UIColumn column = (UIColumn)rowComponent;
                    String value = null;
                    value = facetType.equalsIgnoreCase("header") ? column.getHeaderText() : column.getFooterText();
                    int rowSpan = column.getRowspan();
                    int colSpan = column.getColspan();
                    Cell cell = xlRow.getCell(i);
                    if (rowSpan > 1 || colSpan > 1) {
                        if (rowSpan > 1) {
                            cell = xlRow.createCell((int)((short)i));
                            Boolean rowSpanFlag = false;
                            for (int j = 0; j < sheet.getNumMergedRegions(); ++j) {
                                CellRangeAddress merged = sheet.getMergedRegion(j);
                                if (!merged.isInRange(sheetRowIndex, i)) continue;
                                rowSpanFlag = true;
                            }
                            if (!rowSpanFlag.booleanValue()) {
                                cell.setCellValue(value);
                                cell.setCellStyle(this.facetStyle);
                                sheet.addMergedRegion(new CellRangeAddress(sheetRowIndex, sheetRowIndex + (rowSpan - 1), i, i));
                            }
                        }
                        if (colSpan > 1) {
                            cell = xlRow.createCell((int)((short)i));
                            for (int j = 0; j < sheet.getNumMergedRegions(); ++j) {
                                CellRangeAddress merged = sheet.getMergedRegion(j);
                                if (!merged.isInRange(sheetRowIndex, i)) continue;
                                cell = xlRow.createCell((int)((short)(++i)));
                            }
                            cell.setCellValue(value);
                            cell.setCellStyle(this.facetStyle);
                            sheet.addMergedRegion(new CellRangeAddress(sheetRowIndex, sheetRowIndex, i, i + (colSpan - 1)));
                            i = i + colSpan - 1;
                        }
                    } else {
                        cell = xlRow.createCell((int)((short)i));
                        for (int j = 0; j < sheet.getNumMergedRegions(); ++j) {
                            CellRangeAddress merged = sheet.getMergedRegion(j);
                            if (!merged.isInRange(sheetRowIndex, i)) continue;
                            cell = xlRow.createCell((int)((short)(++i)));
                        }
                        cell.setCellValue(value);
                        cell.setCellStyle(this.facetStyle);
                    }
                    ++i;
                }
            }
        }
    }

    protected void tableColumnGroup(Sheet sheet, SubTable table, String facetType) {
        ColumnGroup cg = table.getColumnGroup(facetType);
        List headerComponentList = null;
        if (cg != null) {
            headerComponentList = cg.getChildren();
        }
        if (headerComponentList != null) {
            for (UIComponent component : headerComponentList) {
                if (!(component instanceof org.primefaces.component.row.Row)) continue;
                org.primefaces.component.row.Row row = (org.primefaces.component.row.Row)component;
                int sheetRowIndex = sheet.getPhysicalNumberOfRows() > 0 ? sheet.getLastRowNum() + 1 : 0;
                Row xlRow = sheet.createRow(sheetRowIndex);
                int i = 0;
                for (UIComponent rowComponent : row.getChildren()) {
                    UIColumn column = (UIColumn)rowComponent;
                    String value = null;
                    value = facetType.equalsIgnoreCase("header") ? column.getHeaderText() : column.getFooterText();
                    int rowSpan = column.getRowspan();
                    int colSpan = column.getColspan();
                    Cell cell = xlRow.getCell(i);
                    if (rowSpan > 1 || colSpan > 1) {
                        if (rowSpan > 1) {
                            cell = xlRow.createCell((int)((short)i));
                            Boolean rowSpanFlag = false;
                            for (int j = 0; j < sheet.getNumMergedRegions(); ++j) {
                                CellRangeAddress merged = sheet.getMergedRegion(j);
                                if (!merged.isInRange(sheetRowIndex, i)) continue;
                                rowSpanFlag = true;
                            }
                            if (!rowSpanFlag.booleanValue()) {
                                cell.setCellStyle(this.cellStyle);
                                cell.setCellValue(value);
                                sheet.addMergedRegion(new CellRangeAddress(sheetRowIndex, sheetRowIndex + rowSpan - 1, i, i));
                            }
                        }
                        if (colSpan > 1) {
                            cell = xlRow.createCell((int)((short)i));
                            for (int j = 0; j < sheet.getNumMergedRegions(); ++j) {
                                CellRangeAddress merged = sheet.getMergedRegion(j);
                                if (!merged.isInRange(sheetRowIndex, i)) continue;
                                cell = xlRow.createCell((int)((short)(++i)));
                            }
                            cell.setCellStyle(this.cellStyle);
                            cell.setCellValue(value);
                            sheet.addMergedRegion(new CellRangeAddress(sheetRowIndex, sheetRowIndex, i, i + colSpan - 1));
                            i = i + colSpan - 1;
                        }
                    } else {
                        cell = xlRow.createCell((int)((short)i));
                        for (int j = 0; j < sheet.getNumMergedRegions(); ++j) {
                            CellRangeAddress merged = sheet.getMergedRegion(j);
                            if (!merged.isInRange(sheetRowIndex, i)) continue;
                            cell = xlRow.createCell((int)((short)(++i)));
                        }
                        cell.setCellValue(value);
                        cell.setCellStyle(this.facetStyle);
                    }
                    ++i;
                }
            }
        }
    }

    protected void exportRow(DataTable table, Sheet sheet, int rowIndex) {
        table.setRowIndex(rowIndex);
        if (!table.isRowAvailable()) {
            return;
        }
        this.exportCells(table, sheet);
    }

    protected void exportRow(SubTable table, Sheet sheet, int rowIndex) {
        table.setRowIndex(rowIndex);
        if (!table.isRowAvailable()) {
            return;
        }
        this.exportCells(table, sheet);
    }

    protected void exportRow(DataList list, Sheet sheet, int rowIndex) {
        list.setRowIndex(rowIndex);
        if (!list.isRowAvailable()) {
            return;
        }
        this.exportCells(list, sheet);
    }

    protected void exportCells(DataTable table, Sheet sheet) {
        DataTable childTable;
        RowExpansion rowExpansion;
        int sheetRowIndex = sheet.getLastRowNum() + 1;
        Row row = sheet.createRow(sheetRowIndex);
        this.facetStyleLeftAlign.setAlignment((short)1);
        this.facetStyleCenterAlign.setAlignment((short)2);
        this.facetStyleRightAlign.setAlignment((short)3);
        this.cellStyleLeftAlign.setAlignment((short)1);
        this.cellStyleCenterAlign.setAlignment((short)2);
        this.cellStyleRightAlign.setAlignment((short)3);
        for (UIColumn col : table.getColumns()) {
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyStatelessModel();
            }
            if (!col.isRendered() || !col.isExportable()) continue;
            this.addColumnValue(row, col.getChildren(), "content");
        }
        FacesContext context = null;
        if (table.getRowIndex() == 0) {
            for (UIComponent component : table.getChildren()) {
                if (!(component instanceof RowExpansion) || (rowExpansion = (RowExpansion)component).getChildren() == null) continue;
                if (rowExpansion.getChildren().get(0) instanceof DataTable) {
                    childTable = (DataTable)rowExpansion.getChildren().get(0);
                    childTable.setRowIndex(-1);
                }
                if (!(rowExpansion.getChildren().get(0) instanceof DataList)) continue;
                DataList childList = (DataList)rowExpansion.getChildren().get(0);
                childList.setRowIndex(-1);
            }
        }
        for (UIComponent component : table.getChildren()) {
            if (!(component instanceof RowExpansion) || (rowExpansion = (RowExpansion)component).getChildren() == null) continue;
            if (rowExpansion.getChildren().get(0) instanceof DataList) {
                DataList list = (DataList)rowExpansion.getChildren().get(0);
                if (list.getHeader() != null) {
                    this.tableFacet(context, sheet, list, "header");
                }
                this.exportAll(context, list, sheet);
            }
            if (!(rowExpansion.getChildren().get(0) instanceof DataTable)) continue;
            childTable = (DataTable)rowExpansion.getChildren().get(0);
            int columnsCount = this.getColumnsCount(childTable);
            if (childTable.getHeader() != null) {
                this.tableFacet(context, sheet, childTable, columnsCount, "header");
            }
            this.tableColumnGroup(sheet, childTable, "header");
            this.addColumnFacets(childTable, sheet, Exporter.ColumnType.HEADER);
            this.exportAll(context, childTable, sheet, false);
            if (childTable.hasFooterColumn()) {
                this.addColumnFacets(childTable, sheet, Exporter.ColumnType.FOOTER);
            }
            this.tableColumnGroup(sheet, childTable, "footer");
            childTable.setRowIndex(-1);
        }
    }

    protected void exportCells(SubTable table, Sheet sheet) {
        int sheetRowIndex = sheet.getLastRowNum() + 1;
        Row row = sheet.createRow(sheetRowIndex);
        this.facetStyleLeftAlign.setAlignment((short)1);
        this.facetStyleCenterAlign.setAlignment((short)2);
        this.facetStyleRightAlign.setAlignment((short)3);
        this.cellStyleLeftAlign.setAlignment((short)1);
        this.cellStyleCenterAlign.setAlignment((short)2);
        this.cellStyleRightAlign.setAlignment((short)3);
        for (UIColumn col : table.getColumns()) {
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyStatelessModel();
            }
            if (!col.isRendered() || !col.isExportable()) continue;
            this.addColumnValue(row, col.getChildren(), "content");
        }
    }

    protected void exportCells(DataList list, Sheet sheet) {
        int sheetRowIndex = sheet.getLastRowNum() + 1;
        Row row = sheet.createRow(sheetRowIndex);
        this.facetStyleLeftAlign.setAlignment((short)1);
        this.facetStyleCenterAlign.setAlignment((short)2);
        this.facetStyleRightAlign.setAlignment((short)3);
        this.cellStyleLeftAlign.setAlignment((short)1);
        this.cellStyleCenterAlign.setAlignment((short)2);
        this.cellStyleRightAlign.setAlignment((short)3);
        for (UIComponent component : list.getChildren()) {
            if (component instanceof Column) {
                UIColumn column = (UIColumn)component;
                for (UIComponent childComponent : column.getChildren()) {
                    short cellIndex = row.getLastCellNum() == -1 ? (short)0 : row.getLastCellNum();
                    Cell cell = row.createCell((int)cellIndex);
                    if (!component.isRendered()) continue;
                    String value = component == null ? "" : this.exportValue(FacesContext.getCurrentInstance(), childComponent);
                    cell.setCellValue((RichTextString)new XSSFRichTextString(value));
                    cell.setCellStyle(this.cellStyle);
                }
                continue;
            }
            short cellIndex = row.getLastCellNum() == -1 ? (short)0 : row.getLastCellNum();
            Cell cell = row.createCell((int)cellIndex);
            if (!component.isRendered()) continue;
            String value = component == null ? "" : this.exportValue(FacesContext.getCurrentInstance(), component);
            cell.setCellValue((RichTextString)new XSSFRichTextString(value));
            cell.setCellStyle(this.cellStyle);
        }
    }

    protected void addColumnFacets(DataTable table, Sheet sheet, Exporter.ColumnType columnType) {
        int sheetRowIndex = sheet.getLastRowNum() + 1;
        Row rowHeader = sheet.createRow(sheetRowIndex);
        for (UIColumn col : table.getColumns()) {
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyStatelessModel();
            }
            if (!col.isRendered() || !col.isExportable()) continue;
            this.addColumnValue(rowHeader, col.getFacet(columnType.facet()), "facet");
        }
    }

    protected void addColumnFacets(SubTable table, Sheet sheet, Exporter.ColumnType columnType) {
        int sheetRowIndex = sheet.getPhysicalNumberOfRows() > 0 ? sheet.getLastRowNum() + 1 : 0;
        Row rowHeader = sheet.createRow(sheetRowIndex);
        for (UIColumn col : table.getColumns()) {
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyStatelessModel();
            }
            if (!col.isRendered() || !col.isExportable()) continue;
            this.addColumnValue(rowHeader, col.getFacet(columnType.facet()), "facet");
        }
    }

    protected void addColumnValue(Row row, UIComponent component, String type) {
        short cellIndex = row.getLastCellNum() == -1 ? (short)0 : row.getLastCellNum();
        Cell cell = row.createCell((int)cellIndex);
        String value = component == null ? "" : this.exportValue(FacesContext.getCurrentInstance(), component);
        cell.setCellValue((RichTextString)new XSSFRichTextString(value));
        if (type.equalsIgnoreCase("facet")) {
            this.addFacetAlignments(component, cell);
        } else {
            this.addColumnAlignments(component, cell);
        }
    }

    protected void addColumnValue(Row row, List<UIComponent> components, String type) {
        short cellIndex = row.getLastCellNum() == -1 ? (short)0 : row.getLastCellNum();
        Cell cell = row.createCell((int)cellIndex);
        StringBuilder builder = new StringBuilder();
        FacesContext context = FacesContext.getCurrentInstance();
        for (UIComponent component : components) {
            String value;
            if (!component.isRendered() || (value = this.exportValue(context, component)) == null) continue;
            builder.append(value);
        }
        cell.setCellValue((RichTextString)new XSSFRichTextString(builder.toString()));
        if (type.equalsIgnoreCase("facet")) {
            for (UIComponent component : components) {
                this.addFacetAlignments(component, cell);
            }
        } else {
            for (UIComponent component : components) {
                this.addColumnAlignments(component, cell);
            }
        }
    }

    protected void addColumnAlignments(UIComponent component, Cell cell) {
        if (component instanceof HtmlOutputText) {
            HtmlOutputText output = (HtmlOutputText)component;
            if (output.getStyle() != null && output.getStyle().contains("left")) {
                cell.setCellStyle(this.cellStyleLeftAlign);
            }
            if (output.getStyle() != null && output.getStyle().contains("right")) {
                cell.setCellStyle(this.cellStyleRightAlign);
            }
            if (output.getStyle() != null && output.getStyle().contains("center")) {
                cell.setCellStyle(this.cellStyleCenterAlign);
            }
        }
    }

    protected void addFacetAlignments(UIComponent component, Cell cell) {
        if (component instanceof HtmlOutputText) {
            HtmlOutputText output = (HtmlOutputText)component;
            if (output.getStyle() != null && output.getStyle().contains("left")) {
                cell.setCellStyle(this.facetStyleLeftAlign);
            } else if (output.getStyle() != null && output.getStyle().contains("right")) {
                cell.setCellStyle(this.facetStyleRightAlign);
            } else {
                cell.setCellStyle(this.facetStyleCenterAlign);
            }
        }
    }

    @Override
    public void customFormat(String facetBackground, String facetFontSize, String facetFontColor, String facetFontStyle, String fontName, String cellFontSize, String cellFontColor, String cellFontStyle, String datasetPadding, String orientation) {
        if (facetBackground != null) {
            this.facetBackground = Color.decode(facetBackground);
        }
        if (facetFontColor != null) {
            this.facetFontColor = Color.decode(facetFontColor);
        }
        if (fontName != null) {
            this.fontName = fontName;
        }
        if (cellFontColor != null) {
            this.cellFontColor = Color.decode(cellFontColor);
        }
        this.facetFontSize = new Short(facetFontSize);
        this.facetFontStyle = facetFontStyle;
        this.cellFontSize = new Short(cellFontSize);
        this.cellFontStyle = cellFontStyle;
        this.datasetPadding = datasetPadding;
    }

    protected void createCustomFonts() {
        XSSFFont facetFont = this.wb.createFont();
        XSSFFont cellFont = this.wb.createFont();
        if (this.cellFontColor != null) {
            XSSFColor cellColor = new XSSFColor(this.cellFontColor);
            cellFont.setColor(cellColor);
        }
        if (this.cellFontSize != null) {
            cellFont.setFontHeightInPoints(this.cellFontSize.shortValue());
        }
        if (this.cellFontStyle.equalsIgnoreCase("BOLD")) {
            cellFont.setBoldweight((short)700);
        }
        if (this.cellFontStyle.equalsIgnoreCase("ITALIC")) {
            cellFont.setItalic(true);
        }
        if (this.facetFontStyle.equalsIgnoreCase("BOLD")) {
            facetFont.setBoldweight((short)700);
        }
        if (this.facetFontStyle.equalsIgnoreCase("ITALIC")) {
            facetFont.setItalic(true);
        }
        if (this.fontName != null) {
            cellFont.setFontName(this.fontName);
            facetFont.setFontName(this.fontName);
        }
        if (this.facetBackground != null) {
            XSSFColor backgroundColor = new XSSFColor(this.facetBackground);
            ((XSSFCellStyle)this.facetStyle).setFillForegroundColor(backgroundColor);
            ((XSSFCellStyle)this.facetStyleLeftAlign).setFillForegroundColor(backgroundColor);
            ((XSSFCellStyle)this.facetStyleCenterAlign).setFillForegroundColor(backgroundColor);
            ((XSSFCellStyle)this.facetStyleRightAlign).setFillForegroundColor(backgroundColor);
            this.facetStyle.setFillPattern((short)1);
            this.facetStyleLeftAlign.setFillPattern((short)1);
            this.facetStyleCenterAlign.setFillPattern((short)1);
            this.facetStyleRightAlign.setFillPattern((short)1);
        }
        if (this.facetFontColor != null) {
            XSSFColor facetColor = new XSSFColor(this.facetFontColor);
            facetFont.setColor(facetColor);
        }
        if (this.facetFontSize != null) {
            facetFont.setFontHeightInPoints(this.facetFontSize.shortValue());
        }
        this.cellStyle.setFont((Font)cellFont);
        this.cellStyleLeftAlign.setFont((Font)cellFont);
        this.cellStyleCenterAlign.setFont((Font)cellFont);
        this.cellStyleRightAlign.setFont((Font)cellFont);
        this.facetStyle.setFont((Font)facetFont);
        this.facetStyleLeftAlign.setFont((Font)facetFont);
        this.facetStyleCenterAlign.setFont((Font)facetFont);
        this.facetStyleRightAlign.setFont((Font)facetFont);
    }

    protected void writeExcelToResponse(ExternalContext externalContext, Workbook generatedExcel, String filename) throws IOException {
        externalContext.setResponseContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        externalContext.setResponseHeader("Expires", "0");
        externalContext.setResponseHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        externalContext.setResponseHeader("Pragma", "public");
        externalContext.setResponseHeader("Content-disposition", "attachment;filename=" + filename + ".xlsx");
        externalContext.addResponseCookie("primefaces.download", "true", Collections.emptyMap());
        OutputStream out = externalContext.getResponseOutputStream();
        generatedExcel.write(out);
        externalContext.responseFlushBuffer();
    }
}

