/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsfcomp.onload;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class OnLoadPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 1L;
    private static Log logger = LogFactory.getLog((Class)OnLoadPhaseListener.class);
    private List rules;

    public OnLoadPhaseListener() {
        logger.info((Object)"OnLoadPhaseListener created");
    }

    public void afterPhase(PhaseEvent event) {
    }

    public void beforePhase(PhaseEvent event) {
        this.processOnLoad(event.getFacesContext(), event.getFacesContext().getViewRoot().getViewId());
    }

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }

    protected boolean beforeHandleNavigation(String requestedViewId, String onLoadAction, String onLoadActionResult) {
        return true;
    }

    private void processOnLoad(FacesContext ctx, String viewId) {
        this.initialize();
        logger.debug((Object)("Processing on load of view " + viewId));
        NavigationRule rule = this.getRule(viewId);
        if (rule == null) {
            logger.debug((Object)("No rule found for view " + viewId));
            return;
        }
        this.processRule(ctx, rule, viewId);
    }

    private NavigationRule getRule(String viewId) {
        logger.debug((Object)("Looking for rule for view " + viewId));
        Iterator iter = this.rules.iterator();
        while (iter.hasNext()) {
            NavigationRule rule = (NavigationRule)iter.next();
            String rViewId = rule.getViewId();
            logger.debug((Object)("Checking for exact match. Rule view: " + rViewId));
            if (rViewId.equals(viewId)) {
                logger.info((Object)"Found rule with exact match");
                return rule;
            }
            if (!rule.getViewId().endsWith("*")) continue;
            String ruleViewPrefix = rule.getViewId();
            ruleViewPrefix = ruleViewPrefix.substring(0, ruleViewPrefix.length() - 1);
            logger.debug((Object)("Checking if view starts with " + ruleViewPrefix));
            if (!viewId.startsWith(ruleViewPrefix)) continue;
            logger.debug((Object)("Found rule for viewId path " + rule.getViewId()));
            return rule;
        }
        return null;
    }

    private void processRule(FacesContext ctx, NavigationRule rule, String viewId) {
        MethodBinding method = ctx.getApplication().createMethodBinding(rule.getAction(), new Class[0]);
        if (method == null) {
            logger.warn((Object)("No method found for rule action " + rule.getAction()));
            return;
        }
        logger.debug((Object)("Invoking action: " + rule.getAction()));
        Object result = method.invoke(ctx, new Object[0]);
        if (result != null && result instanceof String) {
            if (!result.equals(rule.successResult)) {
                if (!this.beforeHandleNavigation(viewId, rule.getAction(), (String)result)) {
                    logger.info((Object)"Before handle navigation has aborted the on load navigation");
                    return;
                }
                logger.debug((Object)("Calling navigation handler with result: " + result));
                ctx.getApplication().getNavigationHandler().handleNavigation(ctx, rule.getAction(), (String)result);
                if (!ctx.getResponseComplete()) {
                    ctx.renderResponse();
                }
            } else {
                logger.debug((Object)("Result is equal to the success result. Result: " + rule.successResult));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Result from rule is null or not a string. Result: " + result));
        }
    }

    private void initialize() {
        if (this.rules != null) {
            return;
        }
        this.loadConfiguration();
    }

    private synchronized void loadConfiguration() {
        if (this.rules != null) {
            return;
        }
        this.rules = new ArrayList();
        FacesContext ctx = FacesContext.getCurrentInstance();
        String url = ctx.getExternalContext().getInitParameter("onload-config");
        try {
            Object rule;
            if (url == null) {
                String msg = "The external context did not have the 'onload-rules' initialization parameter. Please check your configuration.";
                logger.error((Object)msg);
                throw new FacesException(msg);
            }
            logger.info((Object)("On Load configuration is being loaded from " + url));
            InputStream configStream = FacesContext.getCurrentInstance().getExternalContext().getResourceAsStream(url);
            Document xml = new SAXReader().read(configStream);
            Element root = xml.getRootElement();
            List rules = root.elements("navigation-rule");
            logger.info((Object)(rules.size() + " rule(s) have been found"));
            Iterator iter = rules.iterator();
            while (iter.hasNext()) {
                rule = (Element)iter.next();
                this.rules.add(new NavigationRule(rule.elementTextTrim("view-id"), rule.elementTextTrim("action"), rule.elementTextTrim("success-result")));
            }
            Collections.sort(this.rules);
            if (logger.isDebugEnabled()) {
                iter = this.rules.iterator();
                while (iter.hasNext()) {
                    rule = (NavigationRule)iter.next();
                    logger.debug((Object)("Rule: " + rule));
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to parse onload configuration", (Throwable)ex);
        }
    }

    private class NavigationRule
    implements Comparable {
        private final String action;
        private final String viewId;
        private final String successResult;

        NavigationRule(String viewId, String action, String successResult) {
            this.viewId = viewId;
            this.action = action;
            this.successResult = successResult;
        }

        String getSuccessResult() {
            return this.successResult;
        }

        String getAction() {
            return this.action;
        }

        String getViewId() {
            return this.viewId;
        }

        public String toString() {
            return String.format("view-id: %s, action: %s, success-result: %s", this.viewId, this.action, this.successResult);
        }

        public int compareTo(Object rule) {
            if (rule instanceof NavigationRule) {
                return this.viewId.compareTo(((NavigationRule)rule).getViewId()) * -1;
            }
            return 1;
        }
    }
}

