/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsfcomp.chartcreator.utils;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import net.sf.jsfcomp.chartcreator.model.ChartAxisData;
import net.sf.jsfcomp.chartcreator.model.ChartData;
import net.sf.jsfcomp.chartcreator.utils.ChartAxisUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.chart.urls.PieURLGenerator;
import org.jfree.chart.urls.StandardCategoryURLGenerator;
import org.jfree.chart.urls.StandardPieURLGenerator;
import org.jfree.chart.urls.StandardXYURLGenerator;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.statistics.BoxAndWhiskerXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.WindDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYZDataset;

public class ChartUtils {
    private static String[] passthruImgAttributes = new String[]{"alt", "styleClass", "onclick", "ondblclick", "onmousedown", "onmouseup", "onmouseover", "onmousemove", "onmouseout", "onkeypress", "onkeydown", "onkeyup", "usemap"};

    public static void renderPassThruImgAttributes(ResponseWriter responseWriter, UIComponent uIComponent) throws IOException {
        for (int i = 0; i < passthruImgAttributes.length; ++i) {
            Object v = uIComponent.getAttributes().get(passthruImgAttributes[i]);
            if (v == null) continue;
            responseWriter.writeAttribute(passthruImgAttributes[i], v, null);
        }
        if (uIComponent.getAttributes().get("imgTitle") != null) {
            responseWriter.writeAttribute("title", uIComponent.getAttributes().get("imgTitle"), null);
        }
    }

    public static PlotOrientation getPlotOrientation(String string) {
        if (string.equalsIgnoreCase("horizontal")) {
            return PlotOrientation.HORIZONTAL;
        }
        if (string.equalsIgnoreCase("vertical")) {
            return PlotOrientation.VERTICAL;
        }
        throw new RuntimeException("Unsupported plot orientation:" + string);
    }

    public static Color getColor(String string) {
        if (string.startsWith("#")) {
            return new Color(Integer.parseInt(string.substring(1), 16));
        }
        if (string.equalsIgnoreCase("black")) {
            return Color.black;
        }
        if (string.equalsIgnoreCase("gray")) {
            return Color.gray;
        }
        if (string.equalsIgnoreCase("yellow")) {
            return Color.yellow;
        }
        if (string.equalsIgnoreCase("green")) {
            return Color.green;
        }
        if (string.equalsIgnoreCase("blue")) {
            return Color.blue;
        }
        if (string.equalsIgnoreCase("red")) {
            return Color.red;
        }
        if (string.equalsIgnoreCase("orange")) {
            return Color.orange;
        }
        if (string.equalsIgnoreCase("cyan")) {
            return Color.cyan;
        }
        if (string.equalsIgnoreCase("magenta")) {
            return Color.magenta;
        }
        if (string.equalsIgnoreCase("darkgray")) {
            return Color.darkGray;
        }
        if (string.equalsIgnoreCase("lightgray")) {
            return Color.lightGray;
        }
        if (string.equalsIgnoreCase("pink")) {
            return Color.pink;
        }
        if (string.equalsIgnoreCase("white")) {
            return Color.white;
        }
        throw new RuntimeException("Unsupported chart color:" + string);
    }

    public static String resolveContentType(String string) {
        if (string.equalsIgnoreCase("png")) {
            return "img/png";
        }
        if (string.equalsIgnoreCase("jpeg")) {
            return "img/jpeg";
        }
        throw new RuntimeException("Unsupported output format:" + string);
    }

    public static JFreeChart createChartWithType(ChartData chartData) {
        JFreeChart jFreeChart = null;
        Object object = chartData.getDatasource();
        if (object instanceof PieDataset) {
            jFreeChart = ChartUtils.createChartWithPieDataSet(chartData);
        } else if (object instanceof CategoryDataset) {
            jFreeChart = ChartUtils.createChartWithCategoryDataSet(chartData);
        } else if (object instanceof XYDataset) {
            jFreeChart = ChartUtils.createChartWithXYDataSet(chartData);
        } else {
            throw new RuntimeException("Unsupported chart type");
        }
        if (chartData.getLegendFontSize() > 0.0f) {
            jFreeChart.getLegend().setItemFont(LegendTitle.DEFAULT_ITEM_FONT.deriveFont(chartData.getLegendFontSize()));
        }
        if (!chartData.isLegendBorder()) {
            jFreeChart.getLegend().setBorder(0.0, 0.0, 0.0, 0.0);
        }
        return jFreeChart;
    }

    public static void setGeneralChartProperties(JFreeChart jFreeChart, ChartData chartData) {
        jFreeChart.setBackgroundPaint((Paint)ChartUtils.getColor(chartData.getBackground()));
        jFreeChart.getPlot().setBackgroundPaint((Paint)ChartUtils.getColor(chartData.getForeground()));
        jFreeChart.setTitle(chartData.getTitle());
        jFreeChart.setAntiAlias(chartData.isAntialias());
        if (chartData.getAlpha() < 100) {
            jFreeChart.getPlot().setForegroundAlpha((float)chartData.getAlpha() / 100.0f);
        }
    }

    public static JFreeChart createChartWithCategoryDataSet(ChartData chartData) {
        JFreeChart jFreeChart = null;
        PlotOrientation plotOrientation = ChartUtils.getPlotOrientation(chartData.getOrientation());
        CategoryDataset categoryDataset = (CategoryDataset)chartData.getDatasource();
        String string = chartData.getType();
        String string2 = chartData.getXlabel();
        String string3 = chartData.getYlabel();
        boolean bl = chartData.isChart3d();
        boolean bl2 = chartData.isLegend();
        if (string.equalsIgnoreCase("bar")) {
            jFreeChart = bl ? ChartFactory.createBarChart3D((String)"", (String)string2, (String)string3, (CategoryDataset)categoryDataset, (PlotOrientation)plotOrientation, (boolean)bl2, (boolean)true, (boolean)false) : ChartFactory.createBarChart((String)"", (String)string2, (String)string3, (CategoryDataset)categoryDataset, (PlotOrientation)plotOrientation, (boolean)bl2, (boolean)true, (boolean)false);
            ChartUtils.setBarOutline(jFreeChart, chartData);
        } else if (string.equalsIgnoreCase("stackedbar")) {
            jFreeChart = bl ? ChartFactory.createStackedBarChart3D((String)"", (String)string2, (String)string3, (CategoryDataset)categoryDataset, (PlotOrientation)plotOrientation, (boolean)bl2, (boolean)true, (boolean)false) : ChartFactory.createStackedBarChart((String)"", (String)string2, (String)string3, (CategoryDataset)categoryDataset, (PlotOrientation)plotOrientation, (boolean)bl2, (boolean)true, (boolean)false);
            ChartUtils.setBarOutline(jFreeChart, chartData);
        } else if (string.equalsIgnoreCase("line")) {
            jFreeChart = bl ? ChartFactory.createLineChart3D((String)"", (String)string2, (String)string3, (CategoryDataset)categoryDataset, (PlotOrientation)plotOrientation, (boolean)bl2, (boolean)true, (boolean)false) : ChartFactory.createLineChart((String)"", (String)string2, (String)string3, (CategoryDataset)categoryDataset, (PlotOrientation)plotOrientation, (boolean)bl2, (boolean)true, (boolean)false);
        } else if (string.equalsIgnoreCase("area")) {
            jFreeChart = ChartFactory.createAreaChart((String)"", (String)string2, (String)string3, (CategoryDataset)categoryDataset, (PlotOrientation)plotOrientation, (boolean)bl2, (boolean)true, (boolean)false);
        } else if (string.equalsIgnoreCase("stackedarea")) {
            jFreeChart = ChartFactory.createStackedAreaChart((String)"", (String)string2, (String)string3, (CategoryDataset)categoryDataset, (PlotOrientation)plotOrientation, (boolean)bl2, (boolean)true, (boolean)false);
        } else if (string.equalsIgnoreCase("waterfall")) {
            jFreeChart = ChartFactory.createWaterfallChart((String)"", (String)string2, (String)string3, (CategoryDataset)categoryDataset, (PlotOrientation)plotOrientation, (boolean)bl2, (boolean)true, (boolean)false);
        } else if (string.equalsIgnoreCase("gantt")) {
            jFreeChart = ChartFactory.createGanttChart((String)"", (String)string2, (String)string3, (IntervalCategoryDataset)((IntervalCategoryDataset)categoryDataset), (boolean)bl2, (boolean)true, (boolean)false);
        }
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        categoryPlot.setDomainGridlinesVisible(chartData.isDomainGridLines());
        categoryPlot.setRangeGridlinesVisible(chartData.isRangeGridLines());
        if (chartData.getGenerateMap() != null) {
            categoryPlot.getRenderer().setBaseItemURLGenerator((CategoryURLGenerator)new StandardCategoryURLGenerator(""));
        }
        int n = categoryPlot.getDataset().getColumnCount();
        if (chartData.getLineStokeWidth() > 0.0f) {
            for (int i = 0; i <= n; ++i) {
                categoryPlot.getRenderer().setSeriesStroke(i, (Stroke)new BasicStroke(chartData.getLineStokeWidth()));
            }
        }
        ChartUtils.setCategorySeriesColors(jFreeChart, chartData);
        ChartUtils.setCategoryExtensions(jFreeChart, chartData);
        return jFreeChart;
    }

    public static JFreeChart createChartWithPieDataSet(ChartData chartData) {
        PiePlot piePlot;
        PieDataset pieDataset = (PieDataset)chartData.getDatasource();
        String string = chartData.getType();
        boolean bl = chartData.isLegend();
        JFreeChart jFreeChart = null;
        if (string.equalsIgnoreCase("pie")) {
            if (chartData.isChart3d()) {
                jFreeChart = ChartFactory.createPieChart3D((String)"", (PieDataset)pieDataset, (boolean)bl, (boolean)true, (boolean)false);
                piePlot = (PiePlot3D)jFreeChart.getPlot();
                piePlot.setDepthFactor((double)((float)chartData.getDepth() / 100.0f));
            } else {
                jFreeChart = ChartFactory.createPieChart((String)"", (PieDataset)pieDataset, (boolean)bl, (boolean)true, (boolean)false);
            }
        } else if (string.equalsIgnoreCase("ring")) {
            jFreeChart = ChartFactory.createRingChart((String)"", (PieDataset)pieDataset, (boolean)bl, (boolean)true, (boolean)false);
        }
        piePlot = (PiePlot)jFreeChart.getPlot();
        piePlot.setStartAngle((double)chartData.getStartAngle());
        if (chartData.getGenerateMap() != null) {
            piePlot.setURLGenerator((PieURLGenerator)new StandardPieURLGenerator(""));
        }
        ChartUtils.setPieSectionColors(jFreeChart, chartData);
        return jFreeChart;
    }

    public static JFreeChart createChartWithXYDataSet(ChartData chartData) {
        XYDataset xYDataset = (XYDataset)chartData.getDatasource();
        String string = chartData.getType();
        String string2 = chartData.getXlabel();
        String string3 = chartData.getYlabel();
        boolean bl = chartData.isLegend();
        JFreeChart jFreeChart = null;
        PlotOrientation plotOrientation = ChartUtils.getPlotOrientation(chartData.getOrientation());
        if (string.equalsIgnoreCase("timeseries")) {
            jFreeChart = ChartFactory.createTimeSeriesChart((String)"", (String)string2, (String)string3, (XYDataset)xYDataset, (boolean)bl, (boolean)true, (boolean)false);
        } else if (string.equalsIgnoreCase("xyline")) {
            jFreeChart = ChartFactory.createXYLineChart((String)"", (String)string2, (String)string3, (XYDataset)xYDataset, (PlotOrientation)plotOrientation, (boolean)bl, (boolean)true, (boolean)false);
        } else if (string.equalsIgnoreCase("polar")) {
            jFreeChart = ChartFactory.createPolarChart((String)"", (XYDataset)xYDataset, (boolean)bl, (boolean)true, (boolean)false);
        } else if (string.equalsIgnoreCase("scatter")) {
            jFreeChart = ChartFactory.createScatterPlot((String)"", (String)string2, (String)string3, (XYDataset)xYDataset, (PlotOrientation)plotOrientation, (boolean)bl, (boolean)true, (boolean)false);
        } else if (string.equalsIgnoreCase("xyarea")) {
            jFreeChart = ChartFactory.createXYAreaChart((String)"", (String)string2, (String)string3, (XYDataset)xYDataset, (PlotOrientation)plotOrientation, (boolean)bl, (boolean)true, (boolean)false);
        } else if (string.equalsIgnoreCase("xysteparea")) {
            jFreeChart = ChartFactory.createXYStepAreaChart((String)"", (String)string2, (String)string3, (XYDataset)xYDataset, (PlotOrientation)plotOrientation, (boolean)bl, (boolean)true, (boolean)false);
        } else if (string.equalsIgnoreCase("xystep")) {
            jFreeChart = ChartFactory.createXYStepChart((String)"", (String)string2, (String)string3, (XYDataset)xYDataset, (PlotOrientation)plotOrientation, (boolean)bl, (boolean)true, (boolean)false);
        } else if (string.equalsIgnoreCase("bubble")) {
            jFreeChart = ChartFactory.createBubbleChart((String)"", (String)string2, (String)string3, (XYZDataset)((XYZDataset)xYDataset), (PlotOrientation)plotOrientation, (boolean)bl, (boolean)true, (boolean)false);
        } else if (string.equalsIgnoreCase("candlestick")) {
            jFreeChart = ChartFactory.createCandlestickChart((String)"", (String)string2, (String)string3, (OHLCDataset)((OHLCDataset)xYDataset), (boolean)bl);
        } else if (string.equalsIgnoreCase("boxandwhisker")) {
            jFreeChart = ChartFactory.createBoxAndWhiskerChart((String)"", (String)string2, (String)string3, (BoxAndWhiskerXYDataset)((BoxAndWhiskerXYDataset)xYDataset), (boolean)bl);
        } else if (string.equalsIgnoreCase("highlow")) {
            jFreeChart = ChartFactory.createHighLowChart((String)"", (String)string2, (String)string3, (OHLCDataset)((OHLCDataset)xYDataset), (boolean)bl);
        } else if (string.equalsIgnoreCase("histogram")) {
            jFreeChart = ChartFactory.createHistogram((String)"", (String)string2, (String)string3, (IntervalXYDataset)((IntervalXYDataset)xYDataset), (PlotOrientation)plotOrientation, (boolean)bl, (boolean)true, (boolean)false);
        } else if (string.equalsIgnoreCase("wind")) {
            jFreeChart = ChartFactory.createWindPlot((String)"", (String)string2, (String)string3, (WindDataset)((WindDataset)xYDataset), (boolean)bl, (boolean)true, (boolean)false);
        }
        if (jFreeChart.getPlot() instanceof XYPlot) {
            jFreeChart.getXYPlot().setDomainGridlinesVisible(chartData.isDomainGridLines());
            jFreeChart.getXYPlot().setRangeGridlinesVisible(chartData.isRangeGridLines());
            if (chartData.getGenerateMap() != null) {
                jFreeChart.getXYPlot().getRenderer().setURLGenerator((XYURLGenerator)new StandardXYURLGenerator(""));
            }
        }
        ChartUtils.setXYSeriesColors(jFreeChart, chartData);
        ChartUtils.setXYExtensions(jFreeChart, chartData);
        return jFreeChart;
    }

    public static void setCategorySeriesColors(JFreeChart jFreeChart, ChartData chartData) {
        if (jFreeChart.getPlot() instanceof CategoryPlot) {
            CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
            if (chartData.getColors() != null) {
                String[] stringArray = chartData.getColors().split(",");
                for (int i = 0; i < stringArray.length; ++i) {
                    categoryPlot.getRenderer().setSeriesPaint(i, (Paint)ChartUtils.getColor(stringArray[i].trim()));
                }
            }
        }
    }

    public static void setXYSeriesColors(JFreeChart jFreeChart, ChartData chartData) {
        if (jFreeChart.getPlot() instanceof XYPlot && chartData.getColors() != null) {
            XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
            String[] stringArray = chartData.getColors().split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                xYPlot.getRenderer().setSeriesPaint(i, (Paint)ChartUtils.getColor(stringArray[i].trim()));
            }
        }
    }

    public static void setPieSectionColors(JFreeChart jFreeChart, ChartData chartData) {
        if (chartData.getColors() != null) {
            String[] stringArray = chartData.getColors().split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                ((PiePlot)jFreeChart.getPlot()).setSectionPaint(i, (Paint)ChartUtils.getColor(stringArray[i].trim()));
            }
        }
    }

    public static void setBarOutline(JFreeChart jFreeChart, ChartData chartData) {
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        BarRenderer barRenderer = (BarRenderer)categoryPlot.getRenderer();
        barRenderer.setDrawBarOutline(chartData.isOutline());
    }

    public static void setXYExtensions(JFreeChart jFreeChart, ChartData chartData) {
        int n = 1;
        Iterator iterator = chartData.getExtensions().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof ChartAxisData)) continue;
            ChartAxisData chartAxisData = (ChartAxisData)e;
            ChartAxisUtils.createXYSeriesAxis(jFreeChart, chartAxisData, n);
            ++n;
        }
    }

    public static void setCategoryExtensions(JFreeChart jFreeChart, ChartData chartData) {
        int n = 1;
        Iterator iterator = chartData.getExtensions().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof ChartAxisData)) continue;
            ChartAxisData chartAxisData = (ChartAxisData)e;
            ChartAxisUtils.createCategorySeriesAxis(jFreeChart, chartAxisData, n);
            ++n;
        }
    }

    public static boolean useServlet(FacesContext facesContext) {
        String string = facesContext.getExternalContext().getInitParameter("net.sf.jsfcomp.chartcreator.USE_CHARTLET");
        if (string != null) {
            return Boolean.valueOf(string);
        }
        return true;
    }
}

