/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsfcomp.chartcreator.utils;

import java.awt.Font;
import java.awt.Paint;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import net.sf.jsfcomp.chartcreator.model.ChartAxisData;
import net.sf.jsfcomp.chartcreator.utils.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;

public class ChartAxisUtils {
    public static ValueAxis createDateAxis(JFreeChart jFreeChart, ChartAxisData chartAxisData) {
        DateAxis dateAxis = new DateAxis(chartAxisData.getLabel());
        if (chartAxisData.getFormat() != null) {
            dateAxis.setDateFormatOverride((DateFormat)new SimpleDateFormat(chartAxisData.getFormat()));
        }
        dateAxis.setTickUnit(DateAxis.DEFAULT_DATE_TICK_UNIT);
        return dateAxis;
    }

    public static ValueAxis createNumberAxis(JFreeChart jFreeChart, ChartAxisData chartAxisData) {
        NumberAxis numberAxis = new NumberAxis(chartAxisData.getLabel());
        if (chartAxisData.getFormat() != null) {
            numberAxis.setNumberFormatOverride((NumberFormat)new DecimalFormat(chartAxisData.getFormat()));
        }
        return numberAxis;
    }

    public static void createXYSeriesAxis(JFreeChart jFreeChart, ChartAxisData chartAxisData, int n) {
        Object object;
        ValueAxis valueAxis = null;
        if (chartAxisData.getType() != null) {
            if (chartAxisData.getType().equals("number")) {
                valueAxis = ChartAxisUtils.createNumberAxis(jFreeChart, chartAxisData);
            } else if (chartAxisData.getType().equals("date")) {
                valueAxis = ChartAxisUtils.createDateAxis(jFreeChart, chartAxisData);
            }
            if (chartAxisData.getTickLabelFontSize() > 0.0f) {
                object = CategoryAxis.DEFAULT_TICK_LABEL_FONT.deriveFont(chartAxisData.getTickLabelFontSize());
                valueAxis.setTickLabelFont((Font)object);
            }
            valueAxis.setTickLabelsVisible(chartAxisData.isTickLabels());
            valueAxis.setTickMarksVisible(chartAxisData.isTickMarks());
            valueAxis.setVerticalTickLabels(chartAxisData.isVerticalTickLabels());
        }
        object = jFreeChart.getXYPlot();
        if (chartAxisData.isDomain()) {
            object.setDomainAxis(object.getDomainAxisCount() - 1, valueAxis);
        } else {
            object.setRangeAxis(n, valueAxis);
            XYDataset xYDataset = (XYDataset)chartAxisData.getDatasource();
            object.setRenderer(n, (XYItemRenderer)new StandardXYItemRenderer());
            object.setDataset(n, xYDataset);
            object.mapDatasetToRangeAxis(n, n);
        }
        ChartAxisUtils.setXYSeriesAxisColors(chartAxisData, object.getRenderer(n));
    }

    public static void setXYSeriesAxisColors(ChartAxisData chartAxisData, XYItemRenderer xYItemRenderer) {
        if (chartAxisData.getColors() != null) {
            String[] stringArray = chartAxisData.getColors().split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                xYItemRenderer.setSeriesPaint(i, (Paint)ChartUtils.getColor(stringArray[i].trim()));
            }
        }
    }

    public static void createCategorySeriesAxis(JFreeChart jFreeChart, ChartAxisData chartAxisData, int n) {
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        if (chartAxisData.isDomain()) {
            CategoryAxis categoryAxis = new CategoryAxis(chartAxisData.getLabel());
            categoryAxis.setTickLabelsVisible(chartAxisData.isTickLabels());
            categoryAxis.setTickMarksVisible(chartAxisData.isTickMarks());
            if (chartAxisData.getTickLabelFontSize() > 0.0f) {
                Font font = CategoryAxis.DEFAULT_TICK_LABEL_FONT.deriveFont(chartAxisData.getTickLabelFontSize());
                categoryAxis.setTickLabelFont(font);
            }
            if (chartAxisData.isVerticalTickLabels()) {
                categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
            }
            categoryPlot.setDomainAxis(categoryPlot.getDomainAxisCount() - 1, categoryAxis);
        } else {
            ValueAxis valueAxis = ChartAxisUtils.createNumberAxis(jFreeChart, chartAxisData);
            valueAxis.setTickLabelsVisible(chartAxisData.isTickLabels());
            valueAxis.setTickMarksVisible(chartAxisData.isTickMarks());
            if (chartAxisData.getTickLabelFontSize() > 0.0f) {
                Font font = CategoryAxis.DEFAULT_TICK_LABEL_FONT.deriveFont(chartAxisData.getTickLabelFontSize());
                valueAxis.setTickLabelFont(font);
            }
            categoryPlot.setRangeAxis(valueAxis);
        }
    }
}

