/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsfcomp.chartcreator.renderkit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import net.sf.jsfcomp.chartcreator.component.UIChart;
import net.sf.jsfcomp.chartcreator.model.ChartData;
import net.sf.jsfcomp.chartcreator.renderkit.URLTagFragmentGenerator;
import net.sf.jsfcomp.chartcreator.utils.ChartUtils;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.CategoryLabelEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.imagemap.StandardToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.ToolTipTagFragmentGenerator;

public class ChartRenderer
extends Renderer {
    public void encodeBegin(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        UIChart uIChart = (UIChart)uIComponent;
        this.setChartDataAtSession(facesContext, uIChart);
        String string = uIChart.getClientId(facesContext);
        responseWriter.startElement("img", (UIComponent)uIChart);
        responseWriter.writeAttribute("id", (Object)string, null);
        responseWriter.writeAttribute("width", (Object)String.valueOf(uIChart.getWidth()), null);
        responseWriter.writeAttribute("border", (Object)"0", null);
        responseWriter.writeAttribute("height", (Object)String.valueOf(uIChart.getHeight()), null);
        if (ChartUtils.useServlet(facesContext)) {
            responseWriter.writeAttribute("src", (Object)("chartcreatorrequest.chart?ts=" + System.currentTimeMillis() + "&chartId=" + string), null);
        } else {
            String string2 = facesContext.getViewRoot().getViewId();
            String string3 = facesContext.getApplication().getViewHandler().getActionURL(facesContext, string2);
            responseWriter.writeAttribute("src", (Object)(string3 + "?ts=" + System.currentTimeMillis() + "&chartId=" + string), null);
        }
        ChartUtils.renderPassThruImgAttributes(responseWriter, (UIComponent)uIChart);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        UIChart uIChart = (UIChart)uIComponent;
        responseWriter.endElement("img");
        if (uIChart.getGenerateMap() != null) {
            this.writeImageMap(facesContext, uIChart);
        }
    }

    private void setChartDataAtSession(FacesContext facesContext, UIChart uIChart) {
        Map map = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
        String string = uIChart.getClientId(facesContext);
        ChartData chartData = new ChartData(uIChart);
        map.put(string, chartData);
    }

    private void renderImageMapSupport(FacesContext facesContext, UIChart uIChart, ChartRenderingInfo chartRenderingInfo) {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        try {
            Iterator iterator = chartRenderingInfo.getEntityCollection().iterator();
            while (iterator.hasNext()) {
                CategoryLabelEntity categoryLabelEntity;
                ChartEntity chartEntity = (ChartEntity)iterator.next();
                if (!(chartEntity instanceof CategoryLabelEntity) || (categoryLabelEntity = (CategoryLabelEntity)chartEntity).getKey() == null) continue;
                categoryLabelEntity.setToolTipText(categoryLabelEntity.getKey().toString());
                categoryLabelEntity.setURLText("?category=" + categoryLabelEntity.getKey().toString());
            }
            responseWriter.write("<script>");
            responseWriter.write("function chart" + uIChart.getId() + "Click(data) {");
            if (uIChart.getOngeneratedimagemapclick() != null) {
                responseWriter.write("  " + uIChart.getOngeneratedimagemapclick() + "(data);");
            }
            responseWriter.write("}");
            responseWriter.write("</script>");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void writeImageMap(FacesContext facesContext, UIChart uIChart) {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        ExternalContext externalContext = facesContext.getExternalContext();
        Map map = externalContext.getSessionMap();
        String string = uIChart.getClientId(facesContext);
        ChartData chartData = (ChartData)map.get(string);
        JFreeChart jFreeChart = ChartUtils.createChartWithType(chartData);
        ChartUtils.setGeneralChartProperties(jFreeChart, chartData);
        ChartRenderingInfo chartRenderingInfo = new ChartRenderingInfo();
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            if (chartData.getOutput().equalsIgnoreCase("png")) {
                ChartUtilities.writeChartAsPNG((OutputStream)byteArrayOutputStream, (JFreeChart)jFreeChart, (int)chartData.getWidth(), (int)chartData.getHeight(), (ChartRenderingInfo)chartRenderingInfo);
            } else if (chartData.getOutput().equalsIgnoreCase("jpeg")) {
                ChartUtilities.writeChartAsJPEG((OutputStream)byteArrayOutputStream, (JFreeChart)jFreeChart, (int)chartData.getWidth(), (int)chartData.getHeight(), (ChartRenderingInfo)chartRenderingInfo);
            }
            this.renderImageMapSupport(facesContext, uIChart, chartRenderingInfo);
            responseWriter.write(ChartUtilities.getImageMap((String)uIChart.getGenerateMap(), (ChartRenderingInfo)chartRenderingInfo, (ToolTipTagFragmentGenerator)new StandardToolTipTagFragmentGenerator(), (org.jfree.chart.imagemap.URLTagFragmentGenerator)new URLTagFragmentGenerator(uIChart.getId())));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

