/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsfcomp.chartcreator;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jsfcomp.chartcreator.model.ChartData;
import net.sf.jsfcomp.chartcreator.utils.ChartUtils;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;

public class Chartlet
extends HttpServlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getParameter("chartId");
        ChartData chartData = (ChartData)httpServletRequest.getSession().getAttribute(string);
        JFreeChart jFreeChart = ChartUtils.createChartWithType(chartData);
        ChartUtils.setGeneralChartProperties(jFreeChart, chartData);
        try {
            this.writeChart(httpServletResponse, jFreeChart, chartData);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.emptySession(httpServletRequest, string);
        }
    }

    private void writeChart(HttpServletResponse httpServletResponse, JFreeChart jFreeChart, ChartData chartData) throws IOException {
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        httpServletResponse.setContentType(ChartUtils.resolveContentType(chartData.getOutput()));
        if (chartData.getOutput().equalsIgnoreCase("png")) {
            ChartUtilities.writeChartAsPNG((OutputStream)servletOutputStream, (JFreeChart)jFreeChart, (int)chartData.getWidth(), (int)chartData.getHeight());
        } else if (chartData.getOutput().equalsIgnoreCase("jpeg")) {
            ChartUtilities.writeChartAsJPEG((OutputStream)servletOutputStream, (JFreeChart)jFreeChart, (int)chartData.getWidth(), (int)chartData.getHeight());
        }
        servletOutputStream.flush();
        servletOutputStream.close();
    }

    private void emptySession(HttpServletRequest httpServletRequest, String string) {
        httpServletRequest.getSession().removeAttribute(string);
    }
}

