/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsfcomp.chartcreator;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.portlet.RenderResponse;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.sf.jsfcomp.chartcreator.model.ChartData;
import net.sf.jsfcomp.chartcreator.utils.ChartUtils;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;

public class ChartListener
implements PhaseListener {
    public void afterPhase(PhaseEvent phaseEvent) {
        String string = (String)phaseEvent.getFacesContext().getExternalContext().getRequestParameterMap().get("chartId");
        if (string != null) {
            this.handleChartRequest(phaseEvent, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleChartRequest(PhaseEvent phaseEvent, String string) {
        FacesContext facesContext = phaseEvent.getFacesContext();
        ExternalContext externalContext = facesContext.getExternalContext();
        Map map = externalContext.getSessionMap();
        ChartData chartData = (ChartData)map.get(string);
        JFreeChart jFreeChart = ChartUtils.createChartWithType(chartData);
        ChartUtils.setGeneralChartProperties(jFreeChart, chartData);
        try {
            if (externalContext.getResponse() instanceof HttpServletResponse) {
                this.writeChartWithServletResponse((HttpServletResponse)externalContext.getResponse(), jFreeChart, chartData);
            } else if (externalContext.getResponse() instanceof RenderResponse) {
                this.writeChartWithPortletResponse((RenderResponse)externalContext.getResponse(), jFreeChart, chartData);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.emptySession(map, string);
            facesContext.responseComplete();
        }
    }

    public void beforePhase(PhaseEvent phaseEvent) {
    }

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }

    private void writeChartWithServletResponse(HttpServletResponse httpServletResponse, JFreeChart jFreeChart, ChartData chartData) throws IOException {
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        httpServletResponse.setContentType(ChartUtils.resolveContentType(chartData.getOutput()));
        this.writeChart((OutputStream)servletOutputStream, jFreeChart, chartData);
    }

    private void writeChartWithPortletResponse(RenderResponse renderResponse, JFreeChart jFreeChart, ChartData chartData) throws IOException {
        OutputStream outputStream = renderResponse.getPortletOutputStream();
        renderResponse.setContentType(ChartUtils.resolveContentType(chartData.getOutput()));
        this.writeChart(outputStream, jFreeChart, chartData);
    }

    private void writeChart(OutputStream outputStream, JFreeChart jFreeChart, ChartData chartData) throws IOException {
        if (chartData.getOutput().equalsIgnoreCase("png")) {
            ChartUtilities.writeChartAsPNG((OutputStream)outputStream, (JFreeChart)jFreeChart, (int)chartData.getWidth(), (int)chartData.getHeight());
        } else if (chartData.getOutput().equalsIgnoreCase("jpeg")) {
            ChartUtilities.writeChartAsJPEG((OutputStream)outputStream, (JFreeChart)jFreeChart, (int)chartData.getWidth(), (int)chartData.getHeight());
        }
        outputStream.flush();
        outputStream.close();
    }

    private void emptySession(Map map, String string) {
        map.remove(string);
    }
}

