/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_tomahawk.renderkit.html;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UISelectOne;
import javax.faces.component.html.HtmlSelectOneRadio;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_tomahawk.config.MyfacesConfig;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HTML;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;

public class HtmlRadioRendererBase
extends HtmlRenderer {
    private static final Log log = LogFactory.getLog((Class)HtmlRadioRendererBase.class);
    private static final String PAGE_DIRECTION = "pageDirection";
    private static final String LINE_DIRECTION = "lineDirection";

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, UISelectOne.class);
        UISelectOne selectOne = (UISelectOne)uiComponent;
        String layout = this.getLayout((UIComponent)selectOne);
        boolean pageDirectionLayout = false;
        if (layout != null) {
            if (layout.equals(PAGE_DIRECTION)) {
                pageDirectionLayout = true;
            } else if (layout.equals(LINE_DIRECTION)) {
                pageDirectionLayout = false;
            } else {
                log.error((Object)("Wrong layout attribute for component " + selectOne.getClientId(facesContext) + ": " + layout));
            }
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("table", (UIComponent)selectOne);
        HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)selectOne, HTML.SELECT_TABLE_PASSTHROUGH_ATTRIBUTES);
        HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
        if (!pageDirectionLayout) {
            writer.startElement("tr", (UIComponent)selectOne);
        }
        List selectItemList = RendererUtils.getSelectItemList(selectOne);
        Converter converter = HtmlRendererUtils.findUIOutputConverterFailSafe(facesContext, (UIComponent)selectOne);
        Object currentValue = RendererUtils.getObjectValue((UIComponent)selectOne);
        currentValue = RendererUtils.getConvertedStringValue(facesContext, (UIComponent)selectOne, converter, currentValue);
        Iterator it = selectItemList.iterator();
        while (it.hasNext()) {
            SelectItem selectItem = (SelectItem)it.next();
            this.renderGroupOrItemRadio(facesContext, (UIComponent)selectOne, selectItem, currentValue, converter, pageDirectionLayout);
        }
        if (!pageDirectionLayout) {
            writer.endElement("tr");
        }
        writer.endElement("table");
    }

    protected String getLayout(UIComponent selectOne) {
        if (selectOne instanceof HtmlSelectOneRadio) {
            return ((HtmlSelectOneRadio)selectOne).getLayout();
        }
        return (String)selectOne.getAttributes().get("layout");
    }

    protected String getStyleClass(UISelectOne selectOne) {
        if (selectOne instanceof HtmlSelectOneRadio) {
            return ((HtmlSelectOneRadio)selectOne).getStyleClass();
        }
        return (String)selectOne.getAttributes().get("styleClass");
    }

    protected void renderGroupOrItemRadio(FacesContext facesContext, UIComponent uiComponent, SelectItem selectItem, Object currentValue, Converter converter, boolean pageDirectionLayout) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        boolean isSelectItemGroup = selectItem instanceof SelectItemGroup;
        UISelectOne selectOne = (UISelectOne)uiComponent;
        if (isSelectItemGroup) {
            if (pageDirectionLayout) {
                writer.startElement("tr", (UIComponent)selectOne);
            }
            writer.startElement("td", (UIComponent)selectOne);
            writer.write(selectItem.getLabel());
            writer.endElement("td");
            if (pageDirectionLayout) {
                writer.endElement("tr");
                writer.startElement("tr", (UIComponent)selectOne);
            }
            writer.startElement("td", (UIComponent)selectOne);
            writer.startElement("table", (UIComponent)selectOne);
            writer.writeAttribute("border", (Object)"0", null);
            SelectItemGroup group = (SelectItemGroup)selectItem;
            SelectItem[] selectItems = group.getSelectItems();
            for (int i = 0; i < selectItems.length; ++i) {
                this.renderGroupOrItemRadio(facesContext, (UIComponent)selectOne, selectItems[i], currentValue, converter, pageDirectionLayout);
            }
            writer.endElement("td");
            writer.endElement("tr");
            writer.endElement("table");
            writer.endElement("td");
            if (pageDirectionLayout) {
                writer.endElement("tr");
            }
        } else {
            writer.write("\t\t");
            if (pageDirectionLayout) {
                writer.startElement("tr", (UIComponent)selectOne);
            }
            writer.startElement("td", (UIComponent)selectOne);
            writer.startElement("label", (UIComponent)selectOne);
            String itemStrValue = RendererUtils.getConvertedStringValue(facesContext, (UIComponent)selectOne, converter, selectItem.getValue());
            boolean itemDisabled = selectItem.isDisabled();
            boolean itemChecked = itemStrValue.equals(currentValue);
            boolean componentDisabled = this.isDisabled(facesContext, (UIComponent)selectOne);
            String labelClass = componentDisabled || itemDisabled ? (String)selectOne.getAttributes().get("disabledClass") : (String)selectOne.getAttributes().get("enabledClass");
            if (labelClass != null) {
                writer.writeAttribute("class", (Object)labelClass, "labelClass");
            }
            this.renderRadio(facesContext, (UIComponent)selectOne, itemStrValue, selectItem.getLabel(), itemDisabled, itemChecked, false);
            writer.endElement("label");
            writer.endElement("td");
            if (pageDirectionLayout) {
                writer.endElement("tr");
            }
        }
    }

    protected void renderRadio(FacesContext facesContext, UIComponent uiComponent, String value, String label, boolean disabled, boolean checked, boolean renderId) throws IOException {
        String clientId = uiComponent.getClientId(facesContext);
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("input", uiComponent);
        writer.writeAttribute("type", (Object)"radio", null);
        writer.writeAttribute("name", (Object)clientId, null);
        if (renderId) {
            writer.writeAttribute("id", (Object)clientId, null);
        }
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (value != null && value.length() > 0) {
            writer.writeAttribute("value", (Object)value, null);
        }
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        if (disabled || this.isDisabled(facesContext, uiComponent)) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        writer.endElement("input");
        if (label != null && label.length() > 0) {
            writer.write("&#160;");
            writer.writeText((Object)label, null);
        }
    }

    protected boolean isDisabled(FacesContext facesContext, UIComponent uiComponent) {
        boolean readonly;
        boolean disabled;
        if (uiComponent instanceof HtmlSelectOneRadio) {
            disabled = ((HtmlSelectOneRadio)uiComponent).isDisabled();
            readonly = ((HtmlSelectOneRadio)uiComponent).isReadonly();
        } else {
            disabled = RendererUtils.getBooleanAttribute(uiComponent, "disabled", false);
            readonly = RendererUtils.getBooleanAttribute(uiComponent, "readonly", false);
        }
        if (!disabled && readonly) {
            disabled = MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isReadonlyAsDisabledForSelect();
        }
        return disabled;
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        RendererUtils.checkParamValidity(facesContext, uiComponent, null);
        if (uiComponent instanceof EditableValueHolder) {
            HtmlRendererUtils.decodeUISelectOne(facesContext, uiComponent);
        }
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, UIOutput.class);
        return RendererUtils.getConvertedUIOutputValue(facesContext, (UIOutput)uiComponent, submittedValue);
    }
}

